/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.sack;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.sack.SackData;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class SackManager
extends SavedData {
    private static final String NAME = "actuallyadditions_sack_data";
    private static final SackManager blankClient = new SackManager();
    private static final HashMap<UUID, SackData> data = new HashMap();

    public static SackManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (SackManager)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(SackManager::new, SackManager::load), NAME);
        }
        return blankClient;
    }

    public Optional<SackData> getSack(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public SackData getOrCreateSack(UUID uuid) {
        return data.computeIfAbsent(uuid, id -> {
            this.setDirty();
            return new SackData((UUID)id);
        });
    }

    public void removeSack(UUID uuid) {
        this.getSack(uuid).ifPresent(backpack -> {
            data.remove(uuid);
            this.setDirty();
        });
    }

    public Optional<IItemHandler> getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getOptional();
        }
        return Optional.empty();
    }

    public Optional<IItemHandler> getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.has(ActuallyComponents.UUID) && data.containsKey(uuid = (UUID)stack.get(ActuallyComponents.UUID))) {
            return data.get(uuid).getOptional();
        }
        return Optional.empty();
    }

    public Optional<ItemStackHandlerAA> getHandler(ItemStack stack) {
        UUID uuid;
        if (stack.has(ActuallyComponents.UUID) && data.containsKey(uuid = (UUID)stack.get(ActuallyComponents.UUID))) {
            return Optional.of(data.get(uuid).getSpecialHandler());
        }
        return Optional.empty();
    }

    public static SackManager load(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains("Sacks")) {
            ListTag list = nbt.getList("Sacks", 10);
            list.forEach(sackNBT -> SackData.fromNBT((CompoundTag)sackNBT, provider).ifPresent(sack -> data.put(sack.getUuid(), (SackData)sack)));
        }
        return new SackManager();
    }

    @Nonnull
    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag sacks = new ListTag();
        data.forEach((uuid, sackData) -> sacks.add((Object)sackData.toNBT(provider)));
        compound.put("Sacks", (Tag)sacks);
        return compound;
    }
}

