/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;

public class TileEntityBreaker
extends TileEntityInventoryBase
implements MenuProvider {
    public boolean isPlacer;
    private int currentTime;

    public TileEntityBreaker(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state, slots);
    }

    public TileEntityBreaker(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.BREAKER.getTileEntityType(), pos, state, 9);
        this.isPlacer = false;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.getInt("CurrentTime");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityBreaker) {
            TileEntityBreaker tile = (TileEntityBreaker)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityBreaker) {
            TileEntityBreaker tile = (TileEntityBreaker)t;
            tile.serverTick();
        }
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        if (!this.isRedstonePowered && !this.isPulseMode) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 15;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation;
    }

    private void doWork() {
        Direction side = WorldUtil.getDirectionByPistonRotation(this.getBlockState());
        BlockPos breakCoords = this.worldPosition.relative(side);
        BlockState stateToBreak = this.level.getBlockState(breakCoords);
        Block blockToBreak = stateToBreak.getBlock();
        if (!this.isPlacer && blockToBreak != Blocks.AIR && stateToBreak.getDestroySpeed((BlockGetter)this.level, breakCoords) >= 0.0f) {
            List drops = Block.getDrops((BlockState)stateToBreak, (ServerLevel)((ServerLevel)this.level), (BlockPos)breakCoords, (BlockEntity)this.level.getBlockEntity(breakCoords));
            FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.level));
            fake.getInventory().items.set(fake.getInventory().selected, (Object)Items.NETHERITE_PICKAXE.getDefaultInstance());
            if (stateToBreak.canHarvestBlock((BlockGetter)this.level, breakCoords, (Player)fake) && StackUtil.canAddAll(this.inv, drops, false)) {
                this.level.destroyBlock(breakCoords, false);
                StackUtil.addAll(this.inv, drops, false);
                this.setChanged();
            }
        } else if (this.isPlacer) {
            int slot = StackUtil.findFirstFilled((IItemHandler)this.inv);
            if (slot == -1) {
                return;
            }
            this.inv.setStackInSlot(slot, WorldUtil.useItemAtSide(side, this.level, this.worldPosition, this.inv.getStackInSlot(slot)));
        }
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)(this.isPlacer ? "container.actuallyadditions.placer" : "container.actuallyadditions.breaker"));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new ContainerBreaker(windowId, playerInventory, this);
    }

    protected void applyImplicitComponents(@Nonnull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.isPulseMode = (Boolean)input.getOrDefault(ActuallyComponents.PULSE_MODE, (Object)false);
    }

    protected void collectImplicitComponents(@Nonnull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ActuallyComponents.PULSE_MODE, (Object)this.isPulseMode);
    }
}

