/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.registration;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class AABlockReg<B extends Block, I extends Item, T extends BlockEntity>
implements Supplier<Block> {
    private final String name;
    private DeferredBlock<B> block;
    private DeferredItem<I> item;
    private Supplier<BlockEntityType<T>> tileEntityType;

    public AABlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier, BlockEntityType.BlockEntitySupplier<T> tileSupplier) {
        this.name = name;
        this.block = ActuallyBlocks.BLOCKS.register(name, blockSupplier);
        this.item = ActuallyItems.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
        this.tileEntityType = ActuallyBlocks.TILES.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)tileSupplier, (Block[])new Block[]{(Block)this.block.get()}).build(null));
    }

    public AABlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier) {
        this.name = name;
        this.block = ActuallyBlocks.BLOCKS.register(name, blockSupplier);
        this.item = ActuallyItems.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Block get() {
        return (Block)this.block.get();
    }

    public B getBlock() {
        return (B)((Block)this.block.get());
    }

    public I getItem() {
        return (I)((Item)this.item.get());
    }

    @Nonnull
    public BlockEntityType<T> getTileEntityType() {
        return Objects.requireNonNull(this.tileEntityType.get());
    }

    public static class BlockBuilder {
        private final String name;
        private Supplier<Block> blockSupplier;
        private Function<Block, Item> itemSupplier = b -> new BlockItem(b, ActuallyItems.defaultProps());
        private boolean hasTile = false;
        private Supplier<BlockEntityType<?>> tileSupplier;

        private BlockBuilder(String nameIn, Supplier<Block> blockSupplierIn) {
            this.name = nameIn;
            this.blockSupplier = blockSupplierIn;
        }

        public static BlockBuilder block(String nameIn, Supplier<Block> blockSupplierIn) {
            return new BlockBuilder(nameIn, blockSupplierIn);
        }

        public BlockBuilder item(Function<Block, Item> itemSupplierIn) {
            this.itemSupplier = itemSupplierIn;
            return this;
        }

        public BlockBuilder tile(Supplier<BlockEntityType<?>> tileSupplierIn) {
            this.tileSupplier = tileSupplierIn;
            this.hasTile = true;
            return this;
        }
    }
}

