/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.silentchaos512.lib.SilentLib;

public final class NBTToJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private NBTToJson() {
        throw new IllegalAccessError("Utility class");
    }

    public static JsonElement toJson(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            return NBTToJson.toJsonObject((CompoundTag)nbt);
        }
        if (nbt instanceof CollectionTag) {
            return NBTToJson.toJsonArray((CollectionTag)nbt);
        }
        if (nbt instanceof NumericTag) {
            return new JsonPrimitive(((NumericTag)nbt).getAsNumber());
        }
        if (nbt instanceof StringTag) {
            return new JsonPrimitive(nbt.getAsString());
        }
        return JsonNull.INSTANCE;
    }

    public static JsonObject toJsonObject(CompoundTag nbt) {
        JsonObject json = new JsonObject();
        for (String key : nbt.getAllKeys()) {
            Tag element = nbt.get(key);
            if (element == null) continue;
            json.add(key, NBTToJson.toJson(element));
        }
        return json;
    }

    public static JsonArray toJsonArray(CollectionTag<?> nbt) {
        JsonArray json = new JsonArray();
        for (Tag element : nbt) {
            json.add(NBTToJson.toJson(element));
        }
        return json;
    }

    public static String writeFile(JsonObject json) {
        String string;
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        String fileName = "nbt_export_" + dtf.format(now) + ".json";
        String dirPath = "output/silentlib_user";
        File output = new File("output/silentlib_user", fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            SilentLib.LOGGER.error("Could not create directory: {}", (Object)output.getParent());
            return "Could not create output directory";
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);
        try {
            GSON.toJson((JsonElement)json, (Appendable)writer);
            String absolutePath = output.getAbsolutePath();
            SilentLib.LOGGER.info("Wrote model file {}", (Object)absolutePath);
            string = "Wrote to " + absolutePath;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return ex.toString();
            }
        }
        ((Writer)writer).close();
        return string;
    }
}

