/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.network.UpdateSolidPreview;
import com.heaser.pipeconnector.utils.TagUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class SolidPreviewButton
extends BaseButton {
    public SolidPreviewButton(ItemStack stack) {
        super((Component)Component.translatable((String)"item.pipe_connector.gui.button.preview_solid"), 20, 50);
        this.updateLabel(stack);
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        TagUtils.setSolidPreview(itemStack, true);
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSolidPreview(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.updateLabel(itemStack);
    }

    @Override
    public boolean isActive(ItemStack itemStack) {
        return !TagUtils.getSolidPreview(itemStack);
    }

    public void updateLabel(ItemStack stack) {
        boolean solid = TagUtils.getSolidPreview(stack);
        this.setLabel("item.pipe_connector.gui.button.preview_solid", solid ? ChatFormatting.GREEN : ChatFormatting.WHITE);
        if (this.button != null) {
            this.button.setMessage(this.getLabel());
        }
        if (this.button != null) {
            this.button.active = !solid;
        }
    }
}

