/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class RenderUtils {
    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, MalumSpiritType spiritType, float effectScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), effectScalar, effectScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Color primaryColor, Color secondaryColor, float effectScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, (Float t) -> primaryColor, (Float t) -> secondaryColor, effectScalar, effectScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Function<Float, Color> primaryColor, Function<Float, Color> secondaryColor, float effectScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, primaryColor, secondaryColor, effectScalar, effectScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, MalumSpiritType spiritType, float scaleScalar, float alphaScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        RenderUtils.renderEntityTrail(poseStack, builder, trailPointBuilder, entity, (Float t) -> primaryColor, (Float t) -> secondaryColor, scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderEntityTrail(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, TrailPointBuilder trailPointBuilder, Entity entity, Function<Float, Color> primaryColor, Function<Float, Color> secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        poseStack.pushPose();
        float trailOffsetX = (float)Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
        float trailOffsetY = (float)Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
        float trailOffsetZ = (float)Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
        poseStack.translate(-trailOffsetX, -trailOffsetY, -trailOffsetZ);
        float size = 0.5f * scaleScalar;
        float alpha = 0.9f * alphaScalar;
        builder.setAlpha(alpha).renderTrail(poseStack, trailPointBuilder, f -> Float.valueOf(size), f -> builder.setAlpha(alpha * f.floatValue()).setColor(ColorHelper.colorLerp((Easing)Easing.SINE_IN, (float)(f.floatValue() * 2.0f), (Color)((Color)secondaryColor.apply((Float)f)), (Color)((Color)primaryColor.apply((Float)f)))));
        poseStack.translate(trailOffsetX, trailOffsetY, trailOffsetZ);
        poseStack.popPose();
    }
}

