/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sammy.malum.core.handlers.hiding.HiddenTagHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VoidRevelationHandler {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(RevelationType.class, (Object)new RevelationType.Adapter()).create();
    private static boolean checkedFile = false;
    private static RevelationType revelationState = RevelationType.NEOPHYTE;

    @OnlyIn(value=Dist.CLIENT)
    private static Path getPath() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve("malum_extra.json");
    }

    private static void checkFile() {
        if (!checkedFile) {
            try {
                String s = Files.readString(VoidRevelationHandler.getPath(), StandardCharsets.UTF_8);
                RevelationData data = (RevelationData)GSON.fromJson(s, RevelationData.class);
                if (data != null) {
                    revelationState = data.hasSeenIt;
                }
            }
            catch (JsonSyntaxException | IOException exception) {
                revelationState = RevelationType.NEOPHYTE;
            }
            checkedFile = true;
        }
    }

    public static boolean hasSeenTheRevelation(RevelationType type) {
        VoidRevelationHandler.checkFile();
        return revelationState.ordinal() >= type.ordinal();
    }

    public static void seeTheRevelation(RevelationType type) {
        if (!VoidRevelationHandler.hasSeenTheRevelation(type)) {
            revelationState = type;
            try {
                RevelationData data = new RevelationData();
                data.hasSeenIt = type;
                Files.writeString(VoidRevelationHandler.getPath(), (CharSequence)GSON.toJson((Object)data), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HiddenTagHandler.conditionsChanged();
        }
    }

    private static class RevelationData {
        public RevelationType hasSeenIt;

        private RevelationData() {
        }
    }

    public static enum RevelationType {
        NEOPHYTE,
        VOID_READER,
        BLACK_CRYSTAL;


        private static class Adapter
        extends TypeAdapter<RevelationType> {
            private Adapter() {
            }

            public void write(JsonWriter out, RevelationType value) throws IOException {
                switch (value.ordinal()) {
                    case 0: {
                        out.value(false);
                        break;
                    }
                    case 1: {
                        out.value(true);
                        break;
                    }
                    case 2: {
                        out.value("all");
                    }
                }
            }

            public RevelationType read(JsonReader in) throws IOException {
                JsonToken token = in.peek();
                if (token == JsonToken.BOOLEAN && in.nextBoolean()) {
                    return VOID_READER;
                }
                if (token == JsonToken.STRING && in.nextString().equals("all")) {
                    return BLACK_CRYSTAL;
                }
                return NEOPHYTE;
            }
        }
    }
}

