/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model.cosmetic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sammy.malum.MalumMod;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.player.Player;

public class ScarfModel
extends EntityModel<Player> {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(MalumMod.malumPath("scarf"), "main");
    public final ModelPart headScarf;
    public final ModelPart torsoScarf;

    public ScarfModel(ModelPart root) {
        this.headScarf = root.getChild("head_scarf");
        this.torsoScarf = root.getChild("torso_scarf");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        PartDefinition headScarf = partdefinition.addOrReplaceChild("head_scarf", CubeListBuilder.create().texOffs(0, 14).addBox(-4.5f, -2.25f, -4.5f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torsoScarf = partdefinition.addOrReplaceChild("torso_scarf", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, -1.0f, -2.5f, 11.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void copyFromDefault(HumanoidModel model) {
        this.torsoScarf.copyFrom(model.body);
        this.headScarf.copyFrom(model.head);
    }

    public void setupAnim(Player pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.headScarf.render(poseStack, buffer, packedLight, packedOverlay);
        this.torsoScarf.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

