/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.item.HeldItemTracker;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.common.MalumTags;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;

public class TotemBaseRenderer
implements BlockEntityRenderer<TotemBaseBlockEntity> {
    public static final HeldItemTracker STAFF_TRACKER = new HeldItemTracker(p -> p.is(MalumTags.ItemTags.IS_TOTEMIC_TOOL));

    public TotemBaseRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TotemBaseBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (STAFF_TRACKER.isVisible()) {
            int height;
            if (blockEntityIn.cachedRadiusRite == null) {
                return;
            }
            float totemTimer = Mth.clamp((float)((float)blockEntityIn.radiusVisibility + (float)(blockEntityIn.isActiveOrAssembling() ? 1 : -1) * partialTicks), (float)0.0f, (float)40.0f);
            float scalar = Easing.SINE_IN_OUT.ease(STAFF_TRACKER.getDelta(partialTicks), 0.0f, 1.0f) * Easing.SINE_IN_OUT.ease(totemTimer / 40.0f, 0.0f, 1.0f, 1.0f);
            MalumSpiritType spiritType = blockEntityIn.cachedRadiusRite.getIdentifyingSpirit();
            TotemicRiteEffect riteEffect = blockEntityIn.cachedRadiusRite.getRiteEffect(blockEntityIn.isSoulwood);
            BlockPos riteEffectCenter = riteEffect.getRiteEffectCenter(blockEntityIn);
            BlockPos offset = riteEffectCenter.subtract((Vec3i)blockEntityIn.getBlockPos());
            int width = riteEffect.getRiteEffectHorizontalRadius();
            if (width > 1) {
                width = width * 2 + 1;
            }
            if ((height = riteEffect.getRiteEffectVerticalRadius()) > 1) {
                height = height * 2 + 1;
            }
            float shaderWidth = width * 32;
            float shaderHeight = height * 32;
            float distortion = 6.0f + (float)height / 2.0f;
            float sideDistortion = 6.0f + (float)width / 2.0f;
            LodestoneRenderType renderType = LodestoneRenderTypes.ADDITIVE_DISTORTED_TEXTURE.applyWithModifierAndCache(MalumRenderTypeTokens.AREA_COVERAGE, b -> b.setCullState(LodestoneRenderTypes.NO_CULL));
            float index = shaderWidth + distortion;
            float sideIndex = shaderWidth * shaderHeight + sideDistortion;
            VFXBuilders.WorldVFXBuilder builder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((RenderType)LodestoneRenderTypes.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypes.copyAndStore((Object)Float.valueOf(index), (LodestoneRenderType)renderType), s -> {
                s.safeGetUniform("Speed").set(1500.0f);
                s.safeGetUniform("Distortion").set(distortion);
                s.safeGetUniform("Width").set(shaderWidth);
                s.safeGetUniform("Height").set(shaderWidth);
            })).setColor(spiritType.getPrimaryColor(), 0.7f * scalar);
            VFXBuilders.WorldVFXBuilder sideBuilder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((RenderType)LodestoneRenderTypes.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypes.copyAndStore((Object)Float.valueOf(sideIndex), (LodestoneRenderType)renderType), s -> {
                s.safeGetUniform("Speed").set(1500.0f);
                s.safeGetUniform("Distortion").set(sideDistortion);
                s.safeGetUniform("Width").set(shaderWidth);
                s.safeGetUniform("Height").set(shaderHeight);
            })).setColor(spiritType.getPrimaryColor(), 0.7f * scalar);
            poseStack.pushPose();
            poseStack.translate((float)offset.getX() + 0.5f, (float)offset.getY() + 0.5f, (float)offset.getZ() + 0.5f);
            CubeVertexData cubeVertexData = CubeVertexData.makeCubePositions((float)width, (float)height).applyWobble(0.0f, 0.5f, 0.01f).scale(1.05f);
            CubeVertexData inverse = CubeVertexData.makeCubePositions((float)(-width), (float)(-height)).applyWobble(0.0f, 0.5f, 0.01f).scale(1.05f);
            builder.drawCubeSides(poseStack, cubeVertexData, new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST});
            sideBuilder.drawCubeSides(poseStack, cubeVertexData, new Direction[]{Direction.UP, Direction.DOWN});
            builder.setUV(0.0f, 1.0f, 1.0f, 0.0f).setColor(spiritType.getSecondaryColor(), 0.6f * scalar);
            sideBuilder.setUV(0.0f, 1.0f, 1.0f, 0.0f).setColor(spiritType.getSecondaryColor(), 0.6f * scalar);
            builder.drawCubeSides(poseStack, inverse, new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST});
            sideBuilder.drawCubeSides(poseStack, inverse, new Direction[]{Direction.UP, Direction.DOWN});
            poseStack.popPose();
        }
    }
}

