/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.artifice;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.client.renderer.block.artifice.ArtificeAcceptorRenderer;
import com.sammy.malum.client.renderer.block.artifice.SpiritInfluenceRendererData;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.curiosities.spirit_catalyzer.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;

public class SpiritCatalyzerRenderer
implements BlockEntityRenderer<SpiritCatalyzerCoreBlockEntity>,
ArtificeAcceptorRenderer.ArtificeModifierSourceRenderer<SpiritCatalyzerCoreBlockEntity> {
    public SpiritCatalyzerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SpiritCatalyzerCoreBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Vec3 offset;
        ClientLevel level = Minecraft.getInstance().level;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = blockEntityIn.inventory.getStackInSlot(0);
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            offset = SpiritCatalyzerCoreBlockEntity.CATALYZER_ITEM_OFFSET;
            poseStack.translate(offset.x, offset.y, offset.z);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
            poseStack.scale(0.45f, 0.45f, 0.45f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
        if (!(stack = blockEntityIn.augmentInventory.getStackInSlot(0)).isEmpty()) {
            poseStack.pushPose();
            offset = SpiritCatalyzerCoreBlockEntity.CATALYZER_AUGMENT_OFFSET;
            poseStack.translate(offset.x, offset.y, offset.z);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)(-level.getGameTime() % 360L) - partialTicks) * 3.0f));
            poseStack.scale(0.45f, 0.45f, 0.45f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
    }

    @Override
    public void render(SpiritCatalyzerCoreBlockEntity catalyzer, IArtificeAcceptor target, SpiritInfluenceRendererData spiritInfluence, float partialTicks, PoseStack poseStack) {
        poseStack.pushPose();
        BlockPos pos = catalyzer.getBlockPos();
        Vec3 offset = SpiritCatalyzerCoreBlockEntity.CATALYZER_ITEM_OFFSET;
        for (MalumSpiritType spirit : spiritInfluence.keySet()) {
            float delta = spiritInfluence.getDelta(spirit);
            if (!(delta > 0.0f)) continue;
            poseStack.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
            SpiritCatalyzerRenderer.renderBeam(catalyzer, target, poseStack, spirit, delta);
            poseStack.translate((double)pos.getX() + offset.x, (double)pos.getY() + offset.y, (double)pos.getZ() + offset.z);
            FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, spirit, delta, partialTicks);
            poseStack.translate(-offset.x, -offset.y, -offset.z);
        }
        poseStack.popPose();
    }

    private static void renderBeam(SpiritCatalyzerCoreBlockEntity catalyzer, IArtificeAcceptor target, PoseStack poseStack, MalumSpiritType spiritType, float delta) {
        BlockPos catalyzerPos = catalyzer.getBlockPos();
        Vec3 startPos = SpiritCatalyzerCoreBlockEntity.CATALYZER_ITEM_OFFSET.add((double)catalyzerPos.getX(), (double)catalyzerPos.getY(), (double)catalyzerPos.getZ());
        Vec3 targetPos = target.getVisualAccelerationPoint();
        Vec3 difference = targetPos.subtract(startPos);
        float distance = 0.35f + Easing.SINE_OUT.ease(delta, 0.0f, 0.35f, 1.0f);
        Vec3 midPoint = startPos.add(difference.scale((double)distance));
        LodestoneRenderType renderType = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        SpiritBasedWorldVFXBuilder.create(spiritType).setColor(spiritType.getPrimaryColor()).setRenderType((RenderType)renderType).setAlpha(delta).renderBeam(poseStack.last().pose(), startPos, midPoint, 0.4f, b -> b.setColor(spiritType.getSecondaryColor()).setAlpha(0.0f));
    }
}

