/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.scarf;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ScarfRenderHandler {
    public static final WeakHashMap<LivingEntity, ScarfRenderData> SCARF_DATA = new WeakHashMap();

    public static void tickScarfData(ClientTickEvent event) {
        ArrayList<LivingEntity> toRemove = new ArrayList<LivingEntity>();
        for (Map.Entry<LivingEntity, ScarfRenderData> entry : SCARF_DATA.entrySet()) {
            ScarfRenderData data = entry.getValue();
            LivingEntity entity = entry.getKey();
            data.tick(entity);
            if (data.isValid(entity)) continue;
            toRemove.add(entity);
        }
        toRemove.forEach(SCARF_DATA::remove);
    }

    public static void renderScarfData(RenderLevelStageEvent event) {
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 cameraPosition = camera.getPosition();
        poseStack.pushPose();
        poseStack.translate(-cameraPosition.x, -cameraPosition.y, -cameraPosition.z);
        for (Map.Entry<LivingEntity, ScarfRenderData> entry : SCARF_DATA.entrySet()) {
            ScarfRenderData data = entry.getValue();
            LivingEntity entity = entry.getKey();
            float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
            Vec3 position = entity.getPosition(partialTicks);
            poseStack.pushPose();
            poseStack.translate(position.x, position.y, position.z);
            data.render(entity, poseStack, partialTicks);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static ScarfRenderData addScarfRenderer(LivingEntity living, Function<LivingEntity, ScarfRenderData> constructor) {
        return SCARF_DATA.computeIfAbsent(living, constructor);
    }

    public static class ScarfRenderData {
        public final RenderTypeToken token;
        public final TrailPointBuilder points;
        public Supplier<Boolean> isValid = () -> true;
        public Color primaryColor = Color.WHITE;
        public Color secondaryColor = Color.WHITE;
        public float scale = 1.0f;
        public float alpha = 1.0f;

        public ScarfRenderData(RenderTypeToken token, int trailLength) {
            this.token = token;
            this.points = new TrailPointBuilder(() -> trailLength);
        }

        public boolean isValid(LivingEntity entity) {
            return this.isValid.get() != false && !entity.isRemoved() && !entity.isDeadOrDying();
        }

        public ScarfRenderData setPrimaryColor(Color primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public ScarfRenderData setSecondaryColor(Color secondaryColor) {
            this.secondaryColor = secondaryColor;
            return this;
        }

        public ScarfRenderData setPredicate(Supplier<Boolean> isValid) {
            this.isValid = isValid;
            return this;
        }

        public ScarfRenderData setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public ScarfRenderData setAlpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public void render(LivingEntity entity, PoseStack poseStack, float partialTicks) {
            BlockPos blockpos = entity.blockPosition().above(2);
            int light = entity.level().hasChunkAt(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)entity.level(), (BlockPos)blockpos) : 0;
            LodestoneRenderType renderType = LodestoneRenderTypes.TEXTURE.apply(this.token);
            VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType((RenderType)renderType).setLight(light).setAlpha(this.alpha);
            Vec3 scarfStart = this.getScarfStart(entity, partialTicks);
            this.points.setOrigin(scarfStart);
            poseStack.pushPose();
            float trailOffsetX = (float)Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
            float trailOffsetY = (float)Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
            float trailOffsetZ = (float)Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
            poseStack.translate(-trailOffsetX, -trailOffsetY, -trailOffsetZ);
            builder.usePartialTicks(0.0f).renderTrail(poseStack, this.points, f -> Float.valueOf(this.scale * (2.5f - f.floatValue() * 1.75f)), f -> builder.setColor(ColorHelper.colorLerp((Easing)Easing.LINEAR, (float)((float)Mth.floor((float)(f.floatValue() * 4.0f)) / 4.0f), (Color)this.secondaryColor, (Color)this.primaryColor)));
            poseStack.popPose();
        }

        public void tick(LivingEntity entity) {
            Vec3 movement = this.getScarfPointMovement(entity);
            this.points.addTrailPoint(new TrailPoint(this.getScarfStart(entity, 0.0f)));
            this.points.run(t -> t.move(movement));
            List list = this.points.getTrailPoints();
            if (list.size() > 2) {
                float age = ((Integer)this.points.trailLength.get()).intValue();
                for (int i = 0; i < list.size() - 1; ++i) {
                    TrailPoint currentPoint = (TrailPoint)list.get(i);
                    TrailPoint nextPoint = (TrailPoint)list.get(i + 1);
                    float delta = Mth.clamp((float)((float)currentPoint.getAge() / age * 4.0f), (float)0.0f, (float)1.0f);
                    float lerpX = (float)Mth.lerp((double)delta, (double)currentPoint.getPosition().x, (double)nextPoint.getPosition().x);
                    float lerpY = (float)Mth.lerp((double)delta, (double)currentPoint.getPosition().y, (double)nextPoint.getPosition().y);
                    float lerpZ = (float)Mth.lerp((double)delta, (double)currentPoint.getPosition().z, (double)nextPoint.getPosition().z);
                    currentPoint.setPosition(new Vec3((double)lerpX, (double)lerpY, (double)lerpZ));
                }
            }
            this.points.tickTrailPoints();
        }

        public Vec3 getScarfPointMovement(LivingEntity entity) {
            Vec3 lookDirection = entity.getLookAngle().scale(Mth.clamp((double)entity.getDeltaMovement().length(), (double)0.0, (double)1.0));
            double y = -0.02f;
            if (lookDirection.length() < (double)0.1f) {
                lookDirection = entity.getLookAngle().scale((double)0.3f);
                y = -0.08f;
            }
            double x = lookDirection.x * (double)-0.1f;
            double z = lookDirection.z * (double)-0.1f;
            return new Vec3(x, y, z);
        }

        public Vec3 getScarfStart(LivingEntity entity, float partialTicks) {
            Vec3 lookDirection = entity.getForward();
            float upwardsOffset = entity.getBbHeight() * 0.8f;
            Vec3 eyePosition = entity.getPosition(partialTicks).add(0.0, (double)upwardsOffset, 0.0);
            float yRot = (float)(Mth.atan2((double)lookDirection.x, (double)lookDirection.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 offsetPosition = eyePosition.subtract(lookDirection.scale((double)0.2f).add(left.scale((double)-0.2f)));
            float angle = ((float)entity.level().getGameTime() + partialTicks) * 0.05f % 6.28f;
            float offsetStrength = 0.01f;
            float xOffset = Mth.sin((float)(angle * 4.0f)) * offsetStrength;
            float yOffset = Mth.sin((float)(angle * 4.0f)) * offsetStrength;
            float zOffset = Mth.cos((float)(angle * 4.0f)) * offsetStrength;
            return offsetPosition.add((double)xOffset, (double)yOffset, (double)zOffset);
        }
    }
}

