/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.banner;

import com.sammy.malum.common.block.curiosities.banner.SoulwovenBannerBlockEntity;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public class SoulwovenBannerBlock
extends LodestoneEntityBlock<SoulwovenBannerBlockEntity> {
    public static final EnumProperty<BannerType> BANNER_TYPE = EnumProperty.create((String)"banner_type", BannerType.class);
    private static final VoxelShape HANGING_SHAPE_X = Block.box((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape HANGING_SHAPE_Z = Block.box((double)0.0, (double)9.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape MOUNTED_NORTH_SHAPE = Block.box((double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MOUNTED_SOUTH_SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape MOUNTED_WEST_SHAPE = Block.box((double)14.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MOUNTED_EAST_SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);

    public SoulwovenBannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BANNER_TYPE});
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SoulwovenBannerBlockEntity) {
            SoulwovenBannerBlockEntity banner = (SoulwovenBannerBlockEntity)blockEntity;
            stack.set(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)banner.patternData);
        }
        return stack;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BannerType value = (BannerType)((Object)state.getValue(BANNER_TYPE));
        Direction direction = value.direction.getOpposite();
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.empty();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch (((BannerType)((Object)state.getValue(BANNER_TYPE))).ordinal()) {
            case 0: {
                return HANGING_SHAPE_X;
            }
            case 1: {
                return HANGING_SHAPE_Z;
            }
            case 2: {
                return MOUNTED_NORTH_SHAPE;
            }
            case 3: {
                return MOUNTED_SOUTH_SHAPE;
            }
            case 4: {
                return MOUNTED_WEST_SHAPE;
            }
            case 5: {
                return MOUNTED_EAST_SHAPE;
            }
        }
        return super.getShape(state, level, pos, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        if (clickedFace.equals((Object)Direction.DOWN)) {
            return (BlockState)this.defaultBlockState().setValue(BANNER_TYPE, (Comparable)((Object)(context.getHorizontalDirection().getAxis().equals((Object)Direction.Axis.X) ? BannerType.HANGING_X : BannerType.HANGING_Z)));
        }
        if (clickedFace.getAxis().isHorizontal()) {
            return (BlockState)this.defaultBlockState().setValue(BANNER_TYPE, (Comparable)((Object)BannerType.DIRECTION_MAP.get(clickedFace)));
        }
        return null;
    }

    public static enum BannerType implements StringRepresentable
    {
        HANGING_X(Direction.DOWN),
        HANGING_Z(Direction.DOWN),
        MOUNTED_NORTH(Direction.NORTH),
        MOUNTED_SOUTH(Direction.SOUTH),
        MOUNTED_WEST(Direction.WEST),
        MOUNTED_EAST(Direction.EAST);

        private static final BannerType[] VALUES;
        private static final Map<Direction, BannerType> DIRECTION_MAP;
        public final Direction direction;
        final String name = this.name().toLowerCase(Locale.ROOT);

        private BannerType(Direction direction) {
            this.direction = direction;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            VALUES = BannerType.values();
            DIRECTION_MAP = Arrays.stream(VALUES).filter(b -> b.direction.getAxis().isHorizontal()).collect(Collectors.toMap(b -> b.direction, b -> b));
        }
    }
}

