/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.banner;

import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class SoulwovenBannerBlockEntity
extends LodestoneBlockEntity {
    public MalumSpiritType spirit;
    public SoulwovenBannerPatternDataComponent patternData = SoulwovenBannerPatternDataComponent.DEFAULT;
    public boolean intense;

    public SoulwovenBannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MalumBlockEntities.SOULWOVEN_BANNER.get(), pos, state);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)this.patternData);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.patternData = (SoulwovenBannerPatternDataComponent)componentInput.get(MalumDataComponents.SOULWOVEN_BANNER_PATTERN);
    }

    public ItemInteractionResult onUseWithItem(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Item item = pStack.getItem();
            if (item instanceof SpiritShardItem) {
                SpiritShardItem shardItem = (SpiritShardItem)item;
                MalumSpiritType spirit = shardItem.type;
                if (spirit.equals(this.spirit) && this.intense || spirit.equals(MalumSpiritTypes.UMBRAL_SPIRIT)) {
                    return super.onUseWithItem(pPlayer, pStack, pHand);
                }
                if (!pPlayer.isCreative()) {
                    pStack.shrink(1);
                }
                this.setSpirit(serverLevel, spirit);
                pPlayer.swing(pHand, true);
            }
            if (pStack.canPerformAction(ItemAbilities.SHEARS_DISARM) && this.spirit != null) {
                this.setSpirit(serverLevel, null);
                pPlayer.swing(pHand, true);
            }
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.spirit = pTag.contains("spirit") ? MalumSpiritType.getSpiritType(pTag.getString("spirit")) : null;
        this.intense = pTag.getBoolean("intense");
        this.patternData = SoulwovenBannerPatternDataComponent.load(pTag);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.spirit != null) {
            tag.putString("spirit", this.spirit.getIdentifier());
        }
        tag.putBoolean("intense", this.intense);
        this.patternData.save(tag);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("pattern");
    }

    public void setSpirit(ServerLevel level, @Nullable MalumSpiritType spirit) {
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        level.playSound(null, this.worldPosition, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        if (spirit != null) {
            MalumParticleEffectTypes.SOULWOVEN_BANNER_ACTIVATED.createEffect(this.worldPosition).color(spirit).spawn(level);
        }
        this.intense = this.spirit == spirit;
        this.spirit = spirit;
        BlockStateHelper.updateState((Level)level, (BlockPos)this.worldPosition);
    }
}

