/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.runic_workbench;

import com.sammy.malum.common.block.storage.MalumItemHolderBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.packets.particle.rite.BlightTransformItemParticlePacket;
import com.sammy.malum.common.recipe.RunicWorkbenchRecipe;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class RunicWorkbenchBlockEntity
extends MalumItemHolderBlockEntity {
    public static final Vec3 RUNIC_WORKBENCH_ITEM_OFFSET = new Vec3(0.5, 1.25, 0.5);

    public RunicWorkbenchBlockEntity(BlockEntityType<? extends RunicWorkbenchBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RunicWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends RunicWorkbenchBlockEntity>)((BlockEntityType)MalumBlockEntities.RUNIC_WORKBENCH.get()), pos, state);
    }

    @Override
    public Vec3 getItemOffset(float partialTicks) {
        if (this.inventory.getStackInSlot(0).getItem() instanceof SpiritShardItem) {
            float gameTime = (float)this.level.getGameTime() + partialTicks;
            return RUNIC_WORKBENCH_ITEM_OFFSET.add(0.0, (double)((float)Math.sin(gameTime % 360.0f / 20.0f) * 0.05f), 0.0);
        }
        return RUNIC_WORKBENCH_ITEM_OFFSET;
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack heldStack, InteractionHand hand) {
        RunicWorkbenchRecipe recipe;
        ItemStack primaryInput = this.inventory.getStackInSlot(0);
        if (!primaryInput.isEmpty() && (recipe = (RunicWorkbenchRecipe)LodestoneRecipeType.getRecipe((Level)player.level(), (RecipeType)((RecipeType)MalumRecipeTypes.RUNEWORKING.get()), (RecipeInput)new SpiritBasedRecipeInput(primaryInput, heldStack))) != null) {
            Vec3 itemPos = this.getItemPos();
            if (!this.level.isClientSide) {
                if (!player.isCreative()) {
                    primaryInput.shrink(recipe.primaryInput.count());
                    heldStack.shrink(recipe.secondaryInput.getCount());
                }
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, itemPos.x, itemPos.y, itemPos.z, recipe.output.copy()));
                this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.RUNIC_WORKBENCH_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.level.random.nextFloat() * 0.25f);
                Item item = heldStack.getItem();
                if (item instanceof SpiritShardItem) {
                    SpiritShardItem spirit = (SpiritShardItem)item;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new BlightTransformItemParticlePacket(List.of(spirit.type.getIdentifier()), itemPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(player, heldStack, hand);
    }
}

