/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_altar;

import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;

public class AltarCraftingHelper {
    public static Extraction simulateExtraction(IItemHandler inventory, List<SizedIngredient> ingredients) {
        IItemHandlerModifiable frozen = AltarCraftingHelper.frozenCopy(inventory);
        int numberOfItems = 0;
        int numberOfIngredients = 0;
        for (SizedIngredient ingredient : ingredients) {
            NonNullList<ItemStack> extracted = AltarCraftingHelper.extractIngredient((IItemHandler)frozen, (Predicate<ItemStack>)ingredient.ingredient(), ingredient.count(), false);
            int numExtracted = extracted.stream().mapToInt(ItemStack::getCount).sum();
            if (numExtracted != ingredient.count()) {
                return null;
            }
            ++numberOfIngredients;
            numberOfItems += numExtracted;
        }
        return new Extraction(numberOfIngredients, numberOfItems);
    }

    public static SizedIngredient getFirstMissingIngredient(IItemHandler inventory, List<SizedIngredient> ingredients) {
        IItemHandlerModifiable frozen = AltarCraftingHelper.frozenCopy(inventory);
        for (SizedIngredient ingredient : ingredients) {
            NonNullList<ItemStack> extracted = AltarCraftingHelper.extractIngredient((IItemHandler)frozen, (Predicate<ItemStack>)ingredient.ingredient(), ingredient.count(), false);
            int numExtracted = extracted.stream().mapToInt(ItemStack::getCount).sum();
            if (numExtracted == ingredient.count()) continue;
            return new SizedIngredient(ingredient.ingredient(), ingredient.count() - numExtracted);
        }
        return null;
    }

    private static List<SizedIngredient> convertSpiritsToIngredients(List<SpiritIngredient> ingredients) {
        return ingredients.stream().map(ingredient -> new SizedIngredient(Ingredient.of(ingredient.getItems()), ingredient.getCount())).toList();
    }

    private static List<ItemStack> convertSpiritsToItems(List<SpiritIngredient> ingredients) {
        return ingredients.stream().map(SpiritIngredient::getStack).toList();
    }

    public static NonNullList<ItemStack> extractIngredient(IItemHandler inventory, Predicate<ItemStack> ingredient, int count, boolean simulate) {
        int leftToExtract = count;
        NonNullList extracted = NonNullList.create();
        int[] toExtract = new int[inventory.getSlots()];
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.extractItem(i, leftToExtract, true);
            if (!ingredient.test(stack)) continue;
            extracted.add((Object)stack);
            toExtract[i] = stack.getCount();
            if ((leftToExtract -= stack.getCount()) > 0) continue;
            if (!simulate) {
                extracted.clear();
                for (int slot = 0; slot < toExtract.length; ++slot) {
                    extracted.add((Object)inventory.extractItem(slot, toExtract[slot], false));
                }
            }
            return extracted;
        }
        return extracted;
    }

    public static SizedIngredient getNextIngredientToTake(SpiritInfusionRecipe recipe, IItemHandlerModifiable consumedItems) {
        IItemHandlerModifiable frozen = AltarCraftingHelper.frozenCopy((IItemHandler)consumedItems);
        return AltarCraftingHelper.getFirstMissingIngredient((IItemHandler)frozen, recipe.extraIngredients);
    }

    private static IItemHandlerModifiable frozenCopy(IItemHandler inventory) {
        ItemStackHandler handler = new ItemStackHandler(inventory.getSlots());
        for (int i = 0; i < inventory.getSlots(); ++i) {
            handler.setStackInSlot(i, inventory.extractItem(i, 64, true));
        }
        return handler;
    }

    public static Ranking rankRecipe(SpiritInfusionRecipe recipe, ItemStack inputItem, IItemHandlerModifiable spiritContainer, IItemHandlerModifiable pedestalItems, IItemHandlerModifiable consumedItems) {
        SpiritBasedRecipeInput input = new SpiritBasedRecipeInput(inputItem, AltarCraftingHelper.convertSpiritsToItems(recipe.spirits));
        if (!recipe.matches(input, (Level)null)) {
            return null;
        }
        int inputCount = recipe.ingredient.count();
        Extraction spiritRanking = AltarCraftingHelper.simulateExtraction((IItemHandler)spiritContainer, AltarCraftingHelper.convertSpiritsToIngredients(recipe.spirits));
        if (spiritRanking == null) {
            return null;
        }
        Extraction itemRanking = AltarCraftingHelper.simulateExtraction((IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[]{pedestalItems, consumedItems}), recipe.extraIngredients);
        if (itemRanking == null) {
            return null;
        }
        return new Ranking(inputCount, spiritRanking.numberOfStacks, spiritRanking.numberOfItems, itemRanking.numberOfStacks, itemRanking.numberOfItems);
    }

    public static IItemHandlerModifiable createPedestalInventoryCapture(List<IMalumSpecialItemAccessPoint> pedestals) {
        return new CombinedInvWrapper((IItemHandlerModifiable[])pedestals.stream().map(IMalumSpecialItemAccessPoint::getSuppliedInventory).toArray(IItemHandlerModifiable[]::new));
    }

    public static List<IMalumSpecialItemAccessPoint> capturePedestals(Level level, BlockPos pos) {
        return AltarCraftingHelper.capturePedestals(level, pos, 4, 3, 4);
    }

    public static List<IMalumSpecialItemAccessPoint> capturePedestals(Level level, BlockPos pos, int xRange, int yRange, int zRange) {
        return BlockEntityHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (Level)level, (BlockPos)pos, (int)xRange, (int)yRange, (int)zRange).stream().sorted(Comparator.comparingDouble(it -> -pos.distSqr((Vec3i)it.getAccessPointBlockPos()))).collect(Collectors.toList());
    }

    public record Extraction(int numberOfStacks, int numberOfItems) {
    }

    public record Ranking(int inputItemCount, int spiritStackCount, int spiritItemCount, int ingredientStackCount, int ingredientItemCount) implements Comparable<Ranking>
    {
        @Override
        public int compareTo(@NotNull Ranking o) {
            int comparison = this.inputItemCount - o.inputItemCount;
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.spiritStackCount - o.spiritStackCount;
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.spiritItemCount - o.spiritItemCount;
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.ingredientStackCount - o.ingredientStackCount;
            if (comparison != 0) {
                return comparison;
            }
            return this.ingredientItemCount - o.ingredientItemCount;
        }
    }
}

