/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible;

import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import team.lodestar.lodestone.systems.block.WaterLoggedEntityBlock;

public class SpiritCrucibleCoreBlock<T extends SpiritCrucibleCoreBlockEntity>
extends WaterLoggedEntityBlock<T> {
    public static final VoxelShape SHAPE = SpiritCrucibleCoreBlock.makeShape();

    public SpiritCrucibleCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        SpiritCrucibleCoreBlockEntity crucible;
        IItemHandler inv;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof SpiritCrucibleCoreBlockEntity && (inv = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(pLevel, pPos, pState, (BlockEntity)(crucible = (SpiritCrucibleCoreBlockEntity)blockEntity), null)) != null) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)inv);
        }
        return 0;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.75, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

