/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.void_depot;

import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class VoidDepotBlockEntity
extends LodestoneBlockEntity {
    public final List<VoidDepotGoal> goals = new ArrayList<VoidDepotGoal>();
    public final List<String> textToDisplay = new ArrayList<String>();
    public boolean repeatable = false;
    public boolean oncePerPlayer = true;
    public List<UUID> playersWhoCompleted = new ArrayList<UUID>();
    public int nearTimer;
    public float textVisibility = 0.0f;
    public static final StringRepresentable.EnumCodec<VoidDepotGoal.VoidDepotGoalType> CODEC = StringRepresentable.fromEnum(VoidDepotGoal.VoidDepotGoalType::values);

    public VoidDepotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MalumBlockEntities.VOID_DEPOT.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        CompoundTag textTag = new CompoundTag();
        if (!this.textToDisplay.isEmpty()) {
            for (int i = 0; i < this.textToDisplay.size(); ++i) {
                String text = this.textToDisplay.get(i);
                textTag.putString("line_" + i, text);
            }
        }
        compound.put("textDisplay", (Tag)textTag);
        CompoundTag goalsTag = new CompoundTag();
        if (!this.goals.isEmpty()) {
            int goalsSize = this.goals.size();
            for (int i = 0; i < goalsSize; ++i) {
                VoidDepotGoal goal = this.goals.get(i);
                CompoundTag goalTag = goal.serialize();
                goalTag.putString("goalName", goal.index);
                goalTag.putString("type", goal.type.name);
                goalTag.putBoolean("completed", goal.completed);
                goalsTag.put("goal_" + i, (Tag)goalTag);
            }
            goalsTag.putBoolean("repeatable", this.repeatable);
            goalsTag.putBoolean("oncePerPlayer", this.oncePerPlayer);
            if (!this.playersWhoCompleted.isEmpty()) {
                CompoundTag playerList = new CompoundTag();
                for (int i = 0; i < this.playersWhoCompleted.size(); ++i) {
                    playerList.putUUID("player_" + i, this.playersWhoCompleted.get(i));
                }
                goalsTag.put("playersWhoCompleted", (Tag)playerList);
            }
            compound.put("goals", (Tag)goalsTag);
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        int i;
        super.loadAdditional(compound, pRegistries);
        if (compound.contains("textDisplay")) {
            this.textToDisplay.clear();
            CompoundTag textTag = compound.getCompound("textDisplay");
            int lineCount = textTag.size();
            for (i = 0; i < lineCount; ++i) {
                if (!textTag.contains("line_" + i)) continue;
                this.textToDisplay.add(textTag.getString("line_" + i));
            }
        }
        if (compound.contains("goals")) {
            this.goals.clear();
            CompoundTag goalsTag = compound.getCompound("goals");
            int goalCount = goalsTag.size();
            for (i = 0; i < goalCount; ++i) {
                CompoundTag goalTag;
                VoidDepotGoal.VoidDepotGoalType type;
                if (!goalsTag.contains("goal_" + i) || (type = (VoidDepotGoal.VoidDepotGoalType)CODEC.byName((goalTag = goalsTag.getCompound("goal_" + i)).getString("type"))) == null) continue;
                VoidDepotGoal goal = type.deserializer.apply(goalTag);
                goal.setCompleted(goalTag.getBoolean("completed"));
                this.goals.add(goal);
            }
            this.playersWhoCompleted.clear();
            CompoundTag playerList = goalsTag.getCompound("playersWhoCompleted");
            if (!playerList.isEmpty()) {
                int playerCount = playerList.size();
                for (int i2 = 0; i2 < playerCount; ++i2) {
                    if (!playerList.contains("player_" + i2)) continue;
                    this.playersWhoCompleted.add(playerList.getUUID("player_" + i2));
                }
            }
            this.repeatable = goalsTag.getBoolean("repeatable");
            this.oncePerPlayer = goalsTag.getBoolean("oncePerPlayer");
        }
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack stack, InteractionHand hand) {
        if (!this.goals.isEmpty()) {
            if (player.getItemInHand(hand).getItem().equals(MalumItems.VOID_DEPOT.get())) {
                ArrayList<VoidDepotGoal> newGoals = new ArrayList<VoidDepotGoal>();
                for (VoidDepotGoal goal : this.goals) {
                    int amount;
                    if (goal instanceof ItemGoal) {
                        ItemGoal itemGoal = (ItemGoal)goal;
                        amount = Math.max(itemGoal.amount / 2, 1);
                        newGoals.add(new ItemGoal(itemGoal.index, itemGoal.item, amount, Math.min(itemGoal.deliveredAmount, amount)));
                    }
                    if (!(goal instanceof ExperienceGoal)) continue;
                    ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                    amount = Math.max(experienceGoal.amount / 2, 1);
                    newGoals.add(new ExperienceGoal(experienceGoal.index, amount, Math.min(experienceGoal.deliveredAmount, amount)));
                }
                this.goals.clear();
                this.goals.addAll(newGoals);
                BlockStateHelper.updateState((Level)this.level, (BlockPos)this.getBlockPos());
                return ItemInteractionResult.SUCCESS;
            }
            if (player.getItemInHand(hand).getItem().equals(MalumItems.VOID_CONDUIT.get())) {
                ArrayList<VoidDepotGoal> newGoals = new ArrayList<VoidDepotGoal>();
                for (VoidDepotGoal goal : this.goals) {
                    if (goal instanceof ItemGoal) {
                        ItemGoal itemGoal = (ItemGoal)goal;
                        newGoals.add(new ItemGoal(itemGoal.index, itemGoal.item, itemGoal.amount * 2, itemGoal.deliveredAmount));
                    }
                    if (!(goal instanceof ExperienceGoal)) continue;
                    ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                    newGoals.add(new ExperienceGoal(experienceGoal.index, experienceGoal.amount * 2, experienceGoal.deliveredAmount));
                }
                this.goals.clear();
                this.goals.addAll(newGoals);
                BlockStateHelper.updateState((Level)this.level, (BlockPos)this.getBlockPos());
                return ItemInteractionResult.SUCCESS;
            }
            if (this.oncePerPlayer && this.playersWhoCompleted.contains(player.getUUID())) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            boolean isSuccessful = false;
            for (VoidDepotGoal goal : this.goals) {
                int givenQuantity;
                if (goal.isCompleted()) continue;
                if (goal instanceof ItemGoal) {
                    ItemGoal itemGoal = (ItemGoal)goal;
                    if (stack.getItem().equals(itemGoal.item) && (givenQuantity = Math.min(stack.getCount(), itemGoal.amount - itemGoal.deliveredAmount)) > 0) {
                        if (!this.level.isClientSide) {
                            itemGoal.deliveredAmount += givenQuantity;
                            stack.shrink(givenQuantity);
                            if (itemGoal.deliveredAmount >= itemGoal.amount) {
                                itemGoal.setCompleted(true);
                            }
                        }
                        isSuccessful = true;
                    }
                }
                if (!(goal instanceof ExperienceGoal)) continue;
                ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                if (!hand.equals((Object)InteractionHand.MAIN_HAND) || !player.getItemInHand(hand).isEmpty() || (givenQuantity = Math.min(player.totalExperience, experienceGoal.amount - experienceGoal.deliveredAmount)) <= 0) continue;
                if (!this.level.isClientSide) {
                    experienceGoal.deliveredAmount += givenQuantity;
                    player.giveExperiencePoints(-givenQuantity);
                    if (experienceGoal.deliveredAmount >= experienceGoal.amount) {
                        experienceGoal.setCompleted(true);
                    }
                }
                isSuccessful = true;
            }
            if (isSuccessful) {
                boolean isCompleted = this.goals.stream().allMatch(VoidDepotGoal::isCompleted);
                if (isCompleted) {
                    this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 40);
                    if (this.oncePerPlayer) {
                        this.playersWhoCompleted.add(player.getUUID());
                    }
                }
                RandomSource random = this.level.random;
                this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.VOID_EATS_GUNK.get(), SoundSource.PLAYERS, 0.7f, 0.6f + random.nextFloat() * 0.3f);
                this.level.playSound(null, this.worldPosition, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.7f, 0.6f + random.nextFloat() * 0.2f);
                this.level.playSound(null, this.worldPosition, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (random.nextFloat() - random.nextFloat()) * 0.35f + 0.9f);
                BlockStateHelper.updateState((Level)this.level, (BlockPos)this.getBlockPos());
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.onUseWithItem(player, stack, hand);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            BlockPos blockPos;
            Player nearestPlayer;
            WeepingWellParticleEffects.passiveVoidDepotParticles(this);
            if ((float)this.level.getGameTime() % 5.0f == 0.0f && (nearestPlayer = this.level.getNearestPlayer((double)(blockPos = this.getBlockPos()).getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 6.0, false)) != null) {
                this.nearTimer = 10;
            }
            --this.nearTimer;
            if (this.nearTimer > 0 && this.textVisibility < 40.0f) {
                this.textVisibility += 1.0f;
            } else if (this.textVisibility > 0.0f) {
                this.textVisibility -= 1.0f;
            }
        }
    }

    public void onCompletion(ServerLevel level) {
        float pitch = Mth.nextFloat((RandomSource)level.getRandom(), (float)1.5f, (float)1.75f);
        MalumParticleEffectTypes.WEEPING_WELL_REACTS.createEffect(this.worldPosition.getCenter().add(0.0, (double)0.4f, 0.0)).spawn(level);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.FLESH_RING_ABSORBS.get(), SoundSource.HOSTILE, 0.7f, pitch);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.VOID_TRANSMUTATION.get(), SoundSource.HOSTILE, 2.0f, pitch);
        if (this.repeatable) {
            for (VoidDepotGoal goal : this.goals) {
                goal.reset();
            }
        }
        BlockStateHelper.updateState((Level)level, (BlockPos)this.getBlockPos());
    }

    public static abstract class VoidDepotGoal {
        public final VoidDepotGoalType type;
        public final String index;
        public final int amount;
        public int deliveredAmount;
        public boolean completed;

        public VoidDepotGoal(VoidDepotGoalType type, String index, int amount, int deliveredAmount) {
            this.type = type;
            this.index = index;
            this.amount = amount;
            this.deliveredAmount = deliveredAmount;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void reset() {
            this.deliveredAmount = 0;
            this.completed = false;
        }

        public CompoundTag serialize() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("amount", this.amount);
            compoundTag.putInt("deliveredAmount", this.deliveredAmount);
            return compoundTag;
        }

        public static enum VoidDepotGoalType implements StringRepresentable
        {
            ITEM("item", ItemGoal::deserialize),
            EXPERIENCE("experience", ExperienceGoal::deserialize);

            public final String name;
            public final Function<CompoundTag, VoidDepotGoal> deserializer;

            private VoidDepotGoalType(String name, Function<CompoundTag, VoidDepotGoal> deserializer) {
                this.name = name;
                this.deserializer = deserializer;
            }

            public String getSerializedName() {
                return this.name;
            }
        }
    }

    public static class ItemGoal
    extends VoidDepotGoal {
        public final Item item;

        public ItemGoal(String index, Item item, int amount, int deliveredAmount) {
            super(VoidDepotGoal.VoidDepotGoalType.ITEM, index, amount, deliveredAmount);
            this.item = item;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("itemType", BuiltInRegistries.ITEM.getKey((Object)this.item).toString());
            compoundTag.putInt("amount", this.amount);
            compoundTag.putInt("deliveredAmount", this.deliveredAmount);
            return compoundTag;
        }

        public static ItemGoal deserialize(CompoundTag compoundTag) {
            return new ItemGoal(compoundTag.getString("goalName"), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)compoundTag.getString("itemType"))), compoundTag.getInt("amount"), compoundTag.getInt("deliveredAmount"));
        }
    }

    public static class ExperienceGoal
    extends VoidDepotGoal {
        public ExperienceGoal(String index, int amount, int deliveredAmount) {
            super(VoidDepotGoal.VoidDepotGoalType.EXPERIENCE, index, amount, deliveredAmount);
        }

        public static ExperienceGoal deserialize(CompoundTag compoundTag) {
            return new ExperienceGoal(compoundTag.getString("goalName"), compoundTag.getInt("amount"), compoundTag.getInt("deliveredAmount"));
        }
    }
}

