/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.SoundHelper;

public class StaffAbilityData {
    public static Codec<StaffAbilityData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.INT.fieldOf("staffCharge").forGetter(c -> c.staffChargeDebt), (App)Codec.FLOAT.fieldOf("staffChargeProgress").forGetter(c -> Float.valueOf(c.staffChargeDebtCooldown))).apply((Applicative)obj, StaffAbilityData::new));
    public static StreamCodec<ByteBuf, StaffAbilityData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private int staffChargeDebt;
    private float staffChargeDebtCooldown;
    private boolean isDirty;

    public StaffAbilityData() {
    }

    public StaffAbilityData(int staffChargeDebt, float staffChargeDebtCooldown) {
        this.staffChargeDebt = staffChargeDebt;
        this.staffChargeDebtCooldown = staffChargeDebtCooldown;
    }

    public void tickData(LivingEntity livingEntity) {
        if (this.staffChargeDebt > 0) {
            this.reduceStaffChargeCooldown(livingEntity, 1);
        }
    }

    public int getStaffChargeDebt() {
        return this.staffChargeDebt;
    }

    public int getAvailableStaffCharges(LivingEntity livingEntity) {
        return StaffAbilityData.getStaffChargeLimit(livingEntity) - this.staffChargeDebt;
    }

    public boolean canUseStaff(LivingEntity livingEntity) {
        return this.getAvailableStaffCharges(livingEntity) >= 3;
    }

    public void consumeStaffCharge(LivingEntity livingEntity) {
        this.staffChargeDebt = Math.min(this.staffChargeDebt + 3, StaffAbilityData.getStaffChargeLimit(livingEntity));
        this.setDirty(true);
    }

    public int consumeAllStaffCharges(LivingEntity livingEntity) {
        int toll = Mth.floor((float)((float)this.getAvailableStaffCharges(livingEntity) / 3.0f));
        this.staffChargeDebt = this.staffChargeDebt + toll * 3 - 3;
        this.setDirty(true);
        return toll;
    }

    public void reduceStaffChargeCooldown(LivingEntity livingEntity, int staffChargeProgress) {
        this.staffChargeDebtCooldown -= (float)staffChargeProgress;
        if (this.staffChargeDebtCooldown <= 0.0f) {
            this.reduceStaffChargeDebt(livingEntity);
            this.staffChargeDebtCooldown += StaffAbilityData.getStaffChargeCooldown(livingEntity);
        }
    }

    public void reduceStaffChargeDebt(LivingEntity livingEntity) {
        if (this.staffChargeDebt > 0) {
            Player player;
            --this.staffChargeDebt;
            if (!(livingEntity instanceof Player) || !(player = (Player)livingEntity).isCreative()) {
                double pitchOffset = 1.5f - (float)(Mth.ceil((float)this.staffChargeDebt) % 3) * 0.25f;
                DeferredHolder<SoundEvent, SoundEvent> soundType = this.staffChargeDebt % 3 == 0 ? MalumSoundEvents.SPELL_CHARGE_FULL : MalumSoundEvents.SPELL_CHARGE_GROW;
                SoundHelper.playSound((Entity)livingEntity, (SoundEvent)((SoundEvent)soundType.get()), (float)0.75f, (float)((float)(1.0 + pitchOffset)));
            }
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public static int getStaffChargeLimit(LivingEntity livingEntity) {
        return Mth.floor((double)livingEntity.getAttribute(MalumAttributes.CHARGE_CAPACITY).getValue()) * 3;
    }

    public static float getStaffChargeCooldown(LivingEntity living) {
        return StaffAbilityData.getStaffChargeCooldown(living.getAttributeValue(MalumAttributes.CHARGE_RECOVERY_RATE));
    }

    public static int getStaffChargeCooldown(double recoverySpeed) {
        return Mth.floor((double)((double)((Integer)CommonConfig.STAFF_CHARGE_RATE.getConfigValue()).intValue() / recoverySpeed));
    }
}

