/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment.soul_data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

public class LivingSoulData {
    public static final Codec<LivingSoulData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.FLOAT.fieldOf("exposedSoulDuration").forGetter(sd -> Float.valueOf(sd.exposedSoulDuration)), (App)Codec.BOOL.fieldOf("soulless").forGetter(sd -> sd.soulless), (App)Codec.BOOL.fieldOf("spawnerSpawned").forGetter(sd -> sd.spawnerSpawned), (App)Codec.LONG.fieldOf("mostRecentShatter").forGetter(sd -> sd.mostRecentShatter)).apply((Applicative)obj, LivingSoulData::new));
    private float exposedSoulDuration;
    private long mostRecentShatter;
    private boolean soulless;
    private boolean spawnerSpawned;

    public LivingSoulData() {
    }

    private LivingSoulData(float exposedSoulDuration, boolean soulless, boolean spawnerSpawned, long mostRecentShatter) {
        this.exposedSoulDuration = exposedSoulDuration;
        this.soulless = soulless;
        this.spawnerSpawned = spawnerSpawned;
        this.mostRecentShatter = mostRecentShatter;
    }

    public void setExposed() {
        this.setExposedSoulDuration(200.0f);
    }

    public void updateSoullessBehavior(Mob mob) {
        if (this.isSoulless()) {
            ArrayList<Class<AvoidEntityGoal>> goalsToRemove = new ArrayList<Class<AvoidEntityGoal>>(List.of(LookAtPlayerGoal.class, MeleeAttackGoal.class, SwellGoal.class, PanicGoal.class, RandomLookAroundGoal.class, AvoidEntityGoal.class));
            mob.goalSelector.getAvailableGoals().removeIf(g -> goalsToRemove.stream().anyMatch(c -> c.isInstance(g)));
        }
    }

    public void updateSoullessTargeting(LivingChangeTargetEvent event) {
        if (this.isSoulless()) {
            event.setNewAboutToBeSetTarget(null);
        }
    }

    public void tickDuration() {
        if (this.shouldDropSpirits()) {
            this.exposedSoulDuration -= 1.0f;
        }
    }

    public void setMostRecentShatter(long mostRecentShatter) {
        this.mostRecentShatter = mostRecentShatter;
    }

    public long getMostRecentShatter() {
        return this.mostRecentShatter;
    }

    public boolean shouldDropSpirits() {
        return !this.soulless && this.getExposedSoulDuration() > 0.0f;
    }

    public void setExposedSoulDuration(float exposedSoulDuration) {
        this.exposedSoulDuration = exposedSoulDuration;
    }

    public float getExposedSoulDuration() {
        return this.exposedSoulDuration;
    }

    public void setSoulless(boolean soulless) {
        this.soulless = soulless;
    }

    public boolean isSoulless() {
        return this.soulless;
    }

    public void setSpawnerSpawned(boolean spawnerSpawned) {
        this.spawnerSpawned = spawnerSpawned;
    }

    public boolean isSpawnerSpawned() {
        return this.spawnerSpawned;
    }
}

