/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.mojang.datafixers.util.Either;
import com.sammy.malum.common.entity.FloatingEntity;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FloatingItemDestinationData {
    @Nonnull
    private final Either<UUID, BlockPos> targetLocation;

    public FloatingItemDestinationData(LivingEntity targetLocation) {
        this(targetLocation.getUUID());
    }

    public FloatingItemDestinationData(UUID targetLocation) {
        this((Either<UUID, BlockPos>)Either.left((Object)targetLocation));
    }

    public FloatingItemDestinationData(BlockPos targetLocation) {
        this((Either<UUID, BlockPos>)Either.right((Object)targetLocation));
    }

    private FloatingItemDestinationData(@NotNull Either<UUID, BlockPos> targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void save(CompoundTag compound) {
        this.targetLocation.ifLeft(uuid -> compound.putUUID("collectorUUID", uuid));
        this.targetLocation.ifRight(pos -> compound.put("collectorPos", NbtUtils.writeBlockPos((BlockPos)pos)));
    }

    public static FloatingItemDestinationData load(CompoundTag compound) {
        if (compound.contains("collectorUUID")) {
            return new FloatingItemDestinationData(compound.getUUID("collectorUUID"));
        }
        if (compound.contains("collectorPos")) {
            return new FloatingItemDestinationData((BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"collectorPos").orElseThrow());
        }
        return null;
    }

    @NotNull
    public Either<UUID, BlockPos> getTargetLocation() {
        return this.targetLocation;
    }

    public boolean isValid(ServerLevel level) {
        return (Boolean)this.targetLocation.map(uuid -> this.getEntityCollector(level).isPresent(), pos -> level.isOutsideBuildHeight(pos) && level.getWorldBorder().isWithinBounds(pos));
    }

    public Optional<LivingEntity> getEntityCollector(ServerLevel level) {
        return this.getTargetLocation().left().map(uuid -> {
            Entity patt0$temp = level.getEntity(uuid);
            if (patt0$temp instanceof LivingEntity) {
                Player player;
                LivingEntity entity = (LivingEntity)patt0$temp;
                if (entity.isDeadOrDying()) {
                    return null;
                }
                if (entity instanceof Player && (player = (Player)entity).isSpectator()) {
                    return null;
                }
                return entity;
            }
            return null;
        });
    }

    public Optional<Vec3> getDestination(ServerLevel level) {
        return Optional.ofNullable((Vec3)this.targetLocation.map(uuid -> FloatingItemDestinationData.getEntityPosition(level, uuid), BlockPos::getCenter));
    }

    public double getDistance(ServerLevel level, FloatingEntity entity) {
        return this.getDestination(level).map(pos -> pos.distanceToSqr(entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0))).orElse((Double)Double.MAX_VALUE);
    }

    private static Vec3 getEntityPosition(ServerLevel level, UUID uuid) {
        Entity entity = level.getEntity(uuid);
        if (entity != null && entity.isAlive()) {
            return entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
        }
        return null;
    }
}

