/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.oath.deliverance;

import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.MalignantCritEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.EntityHelper;

public class UnsightedResistanceGeas
extends GeasEffect {
    public UnsightedResistanceGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.OATH_OF_UNSIGHTED_RESISTANCE.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("malignant_crit_reinforcement", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("malignant_crit_reduced_damage", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public void finalizedMalignantCritEvent(MalignantCritEvent.Post event, LivingEntity attacker) {
        event.setNewDamage(event.getNewDamage() * 0.8f);
        DeferredHolder<MobEffect, MobEffect> shielding = MalumMobEffects.UNSIGHTED_RESISTANCE;
        MobEffectInstance instance = attacker.getEffect(shielding);
        if (instance == null) {
            attacker.addEffect(new MobEffectInstance(shielding, 100, 0, true, true, true));
        } else {
            EntityHelper.amplifyEffect((MobEffectInstance)instance, (LivingEntity)attacker, (int)1, (int)9);
            EntityHelper.extendEffect((MobEffectInstance)instance, (LivingEntity)attacker, (int)40, (int)400);
        }
    }
}

