/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aqueous;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class HighPriestGeas
extends GeasEffect {
    private static final int COOLDOWN_DURATION = 600;
    public boolean hasEffect = false;

    public HighPriestGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_HIGH_PRIEST.get());
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        if (!this.hasEffect) {
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        }
        return modifiers;
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("bonus_reach", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("fragile_reach", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("fragile_reach_damage", new Object[0]));
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.level().getGameTime() % 5L == 0L) {
            boolean hadEffect = this.hasEffect;
            this.hasEffect = entity.hasEffect(MalumMobEffects.SHAKEN_FAITH);
            if (hadEffect != this.hasEffect) {
                this.setDirty();
            }
        }
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().getDirectEntity() != null && event.getSource().getEntity() != null) {
            if (this.hasEffect) {
                return;
            }
            WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setDamageData(0.0f, 4.0f, 2).setMagicDamageType(MalumDamageTypes.KARMIC).setImpactParticleEffect(MalumParticleEffectTypes.SHAKEN_FAITH, new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.AQUEOUS_SPIRIT)).setSound((Holder<SoundEvent>)MalumSoundEvents.SCYTHE_SWEEP, 0.5f, 1.5f, 0.3f));
            target.addEffect(new MobEffectInstance(MalumMobEffects.SHAKEN_FAITH, 600, 0, true, true, true));
            this.setDirty();
        }
    }
}

