/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aqueous;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.EntityHelper;

public class SelfCareGeas
extends GeasEffect {
    public SelfCareGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_SELF_CARE.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("more_saturation", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("food_effect_cleanse", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("faster_starving", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public static void onEat(Level level, LivingEntity livingEntity, ItemStack food) {
        Player player;
        if (level.isClientSide) {
            return;
        }
        if (livingEntity instanceof Player && GeasEffectHandler.hasGeasEffect((LivingEntity)(player = (Player)livingEntity), MalumGeasEffectTypes.PACT_OF_SELF_CARE)) {
            player.getFoodData().add(0, 1.5f);
            for (MobEffectInstance instance : livingEntity.getActiveEffectsMap().values()) {
                MobEffect e = (MobEffect)instance.getEffect().value();
                if (!e.getCategory().equals((Object)MobEffectCategory.HARMFUL)) continue;
                EntityHelper.shortenEffect((MobEffectInstance)instance, (LivingEntity)livingEntity, (int)80);
            }
        }
    }

    public static int accelerateHunger(LivingEntity entity, int foodLevel) {
        if (GeasEffectHandler.hasGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_SELF_CARE)) {
            if (foodLevel == 0) {
                return 3;
            }
            return entity.getHealth() < entity.getMaxHealth() / 4.0f ? 2 : 1;
        }
        return 0;
    }
}

