/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.eldritch;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class ArcanaphageGeas
extends GeasEffect {
    public ArcanaphageGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_ARCANAPHAGE.get());
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.SPIRIT_SPOILS, 1.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.SOUL_WARD_INTEGRITY, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return modifiers;
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("spirits_magic_boost", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("oops_all_magic", new Object[0]));
    }

    @Override
    public void spiritCollectionEvent(CollectSpiritEvent event, LivingEntity collector, double arcaneResonance) {
        DeferredHolder<MobEffect, MobEffect> effect = MalumMobEffects.ARCANAPHAGE;
        MobEffectInstance instance = collector.getEffect(effect);
        if (instance == null) {
            collector.addEffect(new MobEffectInstance(effect, 100, 0, true, true, true));
        } else {
            if (collector.getRandom().nextBoolean()) {
                EntityHelper.amplifyEffect((MobEffectInstance)instance, (LivingEntity)collector, (int)1, (int)25);
            }
            EntityHelper.extendEffect((MobEffectInstance)instance, (LivingEntity)collector, (int)40, (int)600);
        }
    }

    public void incomingDamageEvent(LivingIncomingDamageEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (!event.getSource().is(LodestoneDamageTypeTags.IS_MAGIC)) {
            event.setCanceled(true);
            target.hurt((DamageSource)new ArcanaphageDamageSource(event.getSource()), event.getAmount());
        }
    }

    public static final class ArcanaphageDamageSource
    extends DamageSource {
        public ArcanaphageDamageSource(DamageSource source) {
            this((Holder<DamageType>)source.typeHolder(), source.getDirectEntity(), source.getEntity(), source.getSourcePosition());
        }

        public ArcanaphageDamageSource(Holder<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity, @Nullable Vec3 damageSourcePosition) {
            super(type, directEntity, causingEntity, damageSourcePosition);
        }

        public boolean is(TagKey<DamageType> damageTypeKey) {
            if (damageTypeKey.equals((Object)LodestoneDamageTypeTags.IS_MAGIC)) {
                return true;
            }
            return super.is(damageTypeKey);
        }
    }
}

