/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.eldritch;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class RuneExploitationGeas
extends GeasEffect {
    private int equippedRuneCount = 0;

    public RuneExploitationGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_RUNE_EXPLOITATION.get());
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        if (this.equippedRuneCount > 0) {
            float debuff = (float)this.equippedRuneCount * -0.1f;
            this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.HEALING_MULTIPLIER, debuff, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)LodestoneAttributes.MAGIC_RESISTANCE, debuff, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ARMOR, debuff, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, debuff, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        return modifiers;
    }

    @Override
    protected void applyAttributeModifiers(LivingEntity entity) {
        super.applyAttributeModifiers(entity);
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(c -> c.addTransientSlotModifier("rune", this.getModifierId(), 2.0, AttributeModifier.Operation.ADD_VALUE));
    }

    @Override
    public void removeAttributeModifiers(LivingEntity entity) {
        super.removeAttributeModifiers(entity);
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(c -> c.removeSlotModifier("rune", this.getModifierId()));
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("more_runes", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("rune_vulnerability", new Object[0]));
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.level().getGameTime() % 40L == 0L) {
            int oldRuneCount = this.equippedRuneCount;
            CuriosApi.getCuriosInventory((LivingEntity)entity).map(ICuriosItemHandler::getEquippedCurios).ifPresent(curiosInventory -> {
                this.equippedRuneCount = 0;
                for (int i = 0; i < curiosInventory.getSlots(); ++i) {
                    ItemStack stack = curiosInventory.getStackInSlot(i);
                    if (stack.isEmpty() || !(stack.getItem() instanceof AbstractRuneCurioItem)) continue;
                    ++this.equippedRuneCount;
                }
            });
            if (oldRuneCount != this.equippedRuneCount) {
                this.setDirty();
            }
        }
    }
}

