/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.eldritch;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.data.attachment.soul_data.LivingSoulData;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.ModifySpiritSpoilsEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class ShatteringAddictGeas
extends GeasEffect {
    public ShatteringAddictGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_SHATTERING_ADDICT.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("chained_spirit_bonus", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("hunger_as_withdrawal", new Object[0]));
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.SPIRIT_SPOILS, 1.0, AttributeModifier.Operation.ADD_VALUE);
        return modifiers;
    }

    @Override
    public void modifySpiritSpoilsEvent(ModifySpiritSpoilsEvent event, LivingEntity attacker) {
        ServerLevel serverLevel;
        long timeSince;
        Level level = attacker.level();
        if (level instanceof ServerLevel && (timeSince = (serverLevel = (ServerLevel)level).getGameTime() - ((LivingSoulData)attacker.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).getMostRecentShatter()) < 2L) {
            event.addBonus(1);
        }
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        ServerLevel serverLevel;
        long timeSince;
        Player player;
        Level level;
        if (entity instanceof Player && (level = (player = (Player)entity).level()) instanceof ServerLevel && (timeSince = (serverLevel = (ServerLevel)level).getGameTime() - ((LivingSoulData)player.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).getMostRecentShatter()) > 32000L) {
            float drain = 0.005f;
            long remainder = timeSince - 32000L;
            while (remainder > 6000L) {
                remainder -= 6000L;
                drain += 0.01f;
            }
            player.causeFoodExhaustion(drain);
        }
    }
}

