/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.infernal;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.EntityHelper;

public class FlameKeeperGeas
extends GeasEffect {
    public FlameKeeperGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_FLAMEKEEPER.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("mining_buffs", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("flamekeeper", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("self_immolation", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public void finalizedIncomingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (!event.getSource().is(DamageTypeTags.IS_FIRE)) {
            MobEffectInstance effect = target.getEffect(MalumMobEffects.FLAMEKEEPERS_FERVOR);
            if (effect != null && effect.amplifier >= 14) {
                target.igniteForSeconds(2.0f);
            }
            FlameKeeperGeas.applyEffect(target);
        }
    }

    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (GeasEffectHandler.hasGeasEffect((LivingEntity)event.getPlayer(), MalumGeasEffectTypes.PACT_OF_THE_FLAMEKEEPER)) {
            FlameKeeperGeas.applyEffect((LivingEntity)event.getPlayer());
        }
    }

    public static void applyEffect(LivingEntity target) {
        DeferredHolder<MobEffect, MobEffect> effect = MalumMobEffects.FLAMEKEEPERS_FERVOR;
        MobEffectInstance instance = target.getEffect(effect);
        if (instance == null) {
            target.addEffect(new MobEffectInstance(effect, 100, 0, true, true, true));
        } else {
            if (target.getRandom().nextFloat() < 0.2f) {
                EntityHelper.amplifyEffect((MobEffectInstance)instance, (LivingEntity)target, (int)1, (int)25);
            }
            EntityHelper.extendEffect((MobEffectInstance)instance, (LivingEntity)target, (int)40, (int)600);
        }
    }
}

