/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.visual_effects.ScreenParticleEffects;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class GeasItem
extends Item
implements ParticleEmitterHandler.ItemParticleSupplier,
ICurioItem {
    public static final String GEAS = "malum.gui.geas.type";
    public static final String SWORN = "malum.gui.geas.sworn";
    public static final String CREATIVE = "malum.gui.geas.creative";
    public static final String CREATIVE_HELP = "malum.gui.geas.creative_help";

    public GeasItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        GeasEffectHandler.getStoredGeasEffect(stack).ifPresent(c -> {
            GeasEffectType geas = c.geasEffectType();
            if (GeasEffectHandler.hasGeasEffect((LivingEntity)player, geas)) {
                GeasEffectHandler.removeGeasEffect((LivingEntity)player, geas);
            } else {
                GeasEffectHandler.addGeasEffect((LivingEntity)player, geas);
            }
        });
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public List<Component> getSlotsTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        return Collections.emptyList();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.has(MalumDataComponents.GEAS_EFFECT)) {
            GeasEffectHandler.getStoredGeasEffect(stack).ifPresent(c -> {
                MutableComponent component = ((Component)tooltipComponents.getFirst()).copy().append(": [").append((Component)Component.translatable((String)c.geasEffectType().getLangKey()).withStyle(ChatFormatting.GOLD)).append("]");
                tooltipComponents.set(0, (Component)component);
            });
        }
    }

    public void spawnEarlyParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        ScreenParticleEffects.spawnGeasItemScreenParticles(target, level, 1.0f, partialTick);
    }

    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        ScreenParticleEffects.spawnSpiritShardScreenParticles(target, MalumSpiritTypes.ELDRITCH_SPIRIT);
    }

    public static void addGeasTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        GeasEffectHandler.getStoredGeasEffect(itemStack).ifPresent(c -> {
            GeasEffect geasEffect;
            Player entity = event.getEntity();
            GeasEffectType geas = c.geasEffectType();
            List tooltip = event.getToolTip();
            AtomicInteger index = new AtomicInteger(1);
            Consumer<Component> tooltipConsumer = t -> tooltip.add(index.getAndIncrement(), t);
            tooltipConsumer.accept((Component)Component.translatable((String)geas.getDescription()).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            tooltipConsumer.accept((Component)Component.translatable((String)"malum.gui.slot").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)GEAS).withStyle(ChatFormatting.YELLOW)));
            if (c.isCreative() && !itemStack.equals(geas.getDummyCreativeStack())) {
                tooltipConsumer.accept((Component)Component.translatable((String)CREATIVE).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
                tooltipConsumer.accept((Component)Component.translatable((String)CREATIVE_HELP).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            }
            tooltipConsumer.accept((Component)Component.empty());
            tooltipConsumer.accept((Component)Component.translatable((String)SWORN).withStyle(ChatFormatting.GOLD));
            GeasEffect geasEffect2 = geasEffect = entity != null ? GeasEffectHandler.getGeasEffect((LivingEntity)entity, c.geasEffectType().getHolder()) : null;
            if (geasEffect == null) {
                geasEffect = c.geasEffectType().getDefaultInstance();
            }
            geasEffect.addTooltipComponents((LivingEntity)entity, tooltipConsumer, event.getFlags());
        });
    }
}

