/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.augment;

import com.sammy.malum.common.data.component.ArtificeAugmentDataComponent;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class AugmentItem
extends Item {
    private static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("#.##%"), f -> f.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public final List<MalumSpiritType> spiritTypes;

    public AugmentItem(Item.Properties pProperties, MalumSpiritType spiritType, ArtificeModifier ... modifiers) {
        this(pProperties, spiritType, false, modifiers);
    }

    public AugmentItem(Item.Properties pProperties, List<MalumSpiritType> spiritTypes, ArtificeModifier ... modifiers) {
        this(pProperties, spiritTypes, false, modifiers);
    }

    public AugmentItem(Item.Properties pProperties, MalumSpiritType spiritType, boolean isCoreAugment, ArtificeModifier ... modifiers) {
        this(pProperties, List.of(spiritType), isCoreAugment, modifiers);
    }

    public AugmentItem(Item.Properties pProperties, List<MalumSpiritType> spiritTypes, boolean isCoreAugment, ArtificeModifier ... modifiers) {
        super(pProperties.component(MalumDataComponents.ARTIFICE_AUGMENT, (Object)new ArtificeAugmentDataComponent(isCoreAugment, List.of(modifiers))));
        this.spiritTypes = spiritTypes;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"malum.gui.slot").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)("malum.gui.augment.type." + this.getAugmentTypeTranslator())).withStyle(ChatFormatting.YELLOW)));
    }

    public static void addAugmentAttributeTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!itemStack.has(MalumDataComponents.ARTIFICE_AUGMENT)) {
            return;
        }
        ArtificeAugmentDataComponent augmentData = (ArtificeAugmentDataComponent)itemStack.get(MalumDataComponents.ARTIFICE_AUGMENT);
        List tooltip = event.getToolTip();
        tooltip.add(Component.empty());
        tooltip.add(Component.translatable((String)"malum.gui.augment.installed").withStyle(ChatFormatting.GOLD));
        for (ArtificeModifier modifier : augmentData.modifiers()) {
            AugmentItem.addAugmentStatComponent(tooltip, modifier.attribute(), modifier.value());
        }
    }

    public String getAugmentTypeTranslator() {
        return "augment";
    }

    public static void addAugmentStatComponent(List<Component> tooltip, ArtificeAttributeType attributeType, float value) {
        boolean inverse = attributeType.equals(ArtificeAttributeType.FUEL_USAGE_RATE) || attributeType.equals(ArtificeAttributeType.INSTABILITY) || attributeType.equals(ArtificeAttributeType.TUNING_STRAIN);
        AugmentItem.makeAugmentStatComponent(attributeType, value, inverse).ifPresent(tooltip::add);
    }

    public static Optional<Component> makeAugmentStatComponent(ArtificeAttributeType attributeType, float value, boolean inverse) {
        return AugmentItem.makeAugmentStatComponent(attributeType.getLangKey(), value, inverse);
    }

    public static Optional<Component> makeAugmentStatComponent(String id, float value, boolean inverse) {
        if (value == 0.0f) {
            return Optional.empty();
        }
        boolean isPositive = value > 0.0f;
        String modifierSign = isPositive ? "attribute.modifier.plus.0" : "attribute.modifier.take.0";
        ChatFormatting style = ChatFormatting.BLUE;
        if (inverse && isPositive || !inverse && !isPositive) {
            style = ChatFormatting.RED;
        }
        return Optional.of(Component.translatable((String)modifierSign, (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(Math.abs(value)), Component.translatable((String)id)}).withStyle(style));
    }
}

