/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities;

import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class LamplightersTongsItem
extends Item {
    public LamplightersTongsItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPlaceContext context = new BlockPlaceContext(pContext);
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn((UseOnContext)context);
        }
        Level level = player.level();
        InteractionHand hand = context.getHand();
        ItemStack spiritStack = player.getItemInHand(hand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        Item item = spiritStack.getItem();
        if (!(item instanceof SpiritShardItem)) {
            return super.useOn((UseOnContext)context);
        }
        SpiritShardItem spiritShard = (SpiritShardItem)item;
        MalumSpiritType spiritType = spiritShard.type;
        BlockState spiritMote = this.getPlacementState(context, spiritType.getSpiritMoteBlockState());
        if (spiritMote == null) {
            return super.useOn((UseOnContext)context);
        }
        BlockPos pPos = context.getClickedPos();
        SoundType soundtype = spiritMote.getSoundType((LevelReader)level, pPos, (Entity)player);
        level.setBlock(pPos, spiritMote, 3);
        level.levelEvent(2001, pPos, Block.getId((BlockState)spiritMote));
        level.playSound(player, pPos, (SoundEvent)MalumSoundEvents.SPIRIT_MOTE_CREATED.get(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, Mth.nextFloat((RandomSource)level.random, (float)1.1f, (float)1.4f));
        if (!player.getAbilities().instabuild) {
            spiritStack.shrink(1);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MalumParticleEffectTypes.SPIRIT_MOTE_SPARKLES.createEffect(pPos).color(spiritType).spawn(serverLevel);
        }
        return InteractionResult.SUCCESS;
    }

    protected BlockState getPlacementState(BlockPlaceContext pContext, BlockState state) {
        return state != null && this.canPlace(pContext, state) ? state : null;
    }

    protected boolean canPlace(BlockPlaceContext pContext, BlockState pState) {
        Player player = pContext.getPlayer();
        CollisionContext collisioncontext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return pContext.getLevel().isUnobstructed(pState, pContext.getClickedPos(), collisioncontext);
    }
}

