/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.runes;

import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.common.spiritrite.PotionRiteEffect;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import top.theillusivec4.curios.api.SlotContext;

public class TotemicRuneCurioItem
extends AbstractRuneCurioItem {
    public final DeferredHolder<MobEffect, MobEffect> mobEffectHolder;
    public final Predicate<LivingEntity> entityPredicate;
    private final int interval;

    public TotemicRuneCurioItem(Item.Properties builder, TotemicRiteType riteType, boolean corrupted) {
        this(builder, riteType, corrupted, 40);
    }

    public TotemicRuneCurioItem(Item.Properties builder, TotemicRiteType riteType, boolean corrupted, int interval) {
        super(builder, riteType.getIdentifyingSpirit());
        this.interval = interval;
        TotemicRiteEffect totemicRiteEffect = riteType.getRiteEffect(corrupted);
        if (!(totemicRiteEffect instanceof PotionRiteEffect)) {
            throw new IllegalArgumentException("Supplied rite type must have an aura effect");
        }
        PotionRiteEffect potionRiteEffect = (PotionRiteEffect)totemicRiteEffect;
        this.mobEffectHolder = potionRiteEffect.mobEffectHolder;
        this.entityPredicate = potionRiteEffect.getEntityPredicate();
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("totem_effect", ((MobEffect)this.mobEffectHolder.get()).getDisplayName()));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!livingEntity.level().isClientSide() && livingEntity.level().getGameTime() % (long)this.interval == 0L && this.entityPredicate.test(livingEntity)) {
            livingEntity.addEffect(new MobEffectInstance(this.mobEffectHolder, 200, 0, true, true));
        }
        super.curioTick(slotContext, stack);
    }
}

