/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.item.tools.LodestoneSwordItem;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class TyrvingItem
extends LodestoneSwordItem
implements IMalumEventResponder,
ISpiritAffiliatedItem {
    public TyrvingItem(Tier tier, float attackDamage, float attackSpeed, LodestoneItemProperties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("soul_based_damage", new Object[0])});
    }

    @Override
    public MalumSpiritType getDefiningSpiritType() {
        return MalumSpiritTypes.WICKED_SPIRIT;
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!event.getSource().is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                return;
            }
            float magicDamage = EntitySpiritDropData.getSpiritData(target).map(EntitySpiritDropData::getTotalSpirits).orElse(0).intValue();
            if (target instanceof Player) {
                magicDamage = 2.0f * Math.max(1.0f, (1.0f + (float)target.getArmorValue() / 12.0f) * (1.0f + (1.0f - 1.0f / (float)target.getArmorValue())) / 12.0f);
            }
            if (target.isAlive()) {
                target.invulnerableTime = 0;
                target.hurt(DamageTypeHelper.create((Level)level2, MalumDamageTypes.TYRVING, (Entity)attacker), magicDamage);
            }
            if (target.isAlive()) {
                WorldEventHandler.addWorldEvent((Level)level2, (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setMagicDamageType(MalumDamageTypes.TYRVING).setDamageData(0.0f, magicDamage, 3));
            }
            SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.TYRVING_SLASH.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)attacker.getRandom(), (float)1.0f, (float)1.5f));
            MalumParticleEffectTypes.TYRVING_SLASH.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).verticalSlashRotation().color(stack.getItem()).horizontalOffset(0.2f).forwardOffset(0.8f).upwardOffset(-0.2f).spawn(level2);
        }
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility.equals(ItemAbilities.SWORD_DIG);
    }
}

