/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.food;

import com.sammy.malum.common.effect.gluttony.GluttonyEffect;
import com.sammy.malum.common.item.food.BottledDrinkItem;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.visual_effects.networked.gluttony.AbsorbGluttonyParticleEffect;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class ConcentratedGluttonyItem
extends BottledDrinkItem {
    public static final Collection<Holder<Item>> ROTTEN_TRINKETS = List.of(MalumItems.RING_OF_DESPERATE_VORACITY, MalumItems.GLUTTONOUS_BROOCH, MalumItems.BELT_OF_THE_STARVED);
    public static final Collection<Holder<GeasEffectType>> ROTTEN_GEAS = List.of(MalumGeasEffectTypes.PACT_OF_THE_PROFANE_ASCETIC, MalumGeasEffectTypes.PACT_OF_THE_PROFANE_GLUTTON);

    public ConcentratedGluttonyItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        GluttonyEffect.GluttonyEffectProperties properties = ConcentratedGluttonyItem.applyConcentratedGluttonyEffect(pEntityLiving, 1.0f);
        SoundHelper.playSound((Entity)pEntityLiving, (SoundEvent)((SoundEvent)MalumSoundEvents.CONCENTRATED_GLUTTONY_DRINK.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)pLevel.random, (float)1.5f, (float)2.0f));
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            MobEffectInstance instance = pEntityLiving.getEffect(properties.getEffectType());
            if (instance != null) {
                ConcentratedGluttonyItem.createGluttonyVFX(serverLevel, pEntityLiving, instance.getAmplifier());
            }
        }
        return super.finishUsingItem(pStack, pLevel, pEntityLiving);
    }

    public static GluttonyEffect.GluttonyEffectProperties applyConcentratedGluttonyEffect(LivingEntity target, float durationScalar) {
        return GluttonyEffect.applyGluttony(target, b -> {
            int amplifier = 3;
            int duration = 20;
            if (CurioHelper.hasCurioEquipped((LivingEntity)target, (Item)((Item)MalumItems.RING_OF_GRUESOME_CONCENTRATION.get()))) {
                ++amplifier;
                duration += 40;
            }
            for (Holder<Item> holder : ROTTEN_TRINKETS) {
                if (!CurioHelper.hasCurioEquipped((LivingEntity)target, (Item)((Item)holder.value()))) continue;
                ++amplifier;
                duration += 10;
            }
            for (Holder holder : ROTTEN_GEAS) {
                if (!GeasEffectHandler.hasGeasEffect(target, (Holder<GeasEffectType>)holder)) continue;
                ++amplifier;
                duration += 40;
            }
            b.setInitialData((int)((float)(duration * 20) * durationScalar), amplifier);
        });
    }

    public static void createGluttonyVFX(ServerLevel serverLevel, LivingEntity target, int amplifier) {
        ConcentratedGluttonyItem.createGluttonyVFX(serverLevel, target, 1.0f + (float)amplifier * 0.05f);
    }

    public static void createGluttonyVFX(ServerLevel serverLevel, LivingEntity target, float potency) {
        Vec3 position = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
        MalumParticleEffectTypes.GLUTTONY_ABSORB.createEffect(position).customData(new AbsorbGluttonyParticleEffect.AbsorbGluttonyEffectData(potency)).spawn(serverLevel);
    }
}

