/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.systems.recipe.LodestoneInWorldRecipe;

public class SpiritInfusionRecipe
extends LodestoneInWorldRecipe<SpiritBasedRecipeInput> {
    public static final MapCodec<SpiritInfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)SizedIngredient.FLAT_CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)SizedIngredient.FLAT_CODEC.listOf().optionalFieldOf("extraIngredients", List.of()).forGetter(recipe -> recipe.extraIngredients), (App)SpiritIngredient.CODEC.codec().listOf().fieldOf("spirits").forGetter(recipe -> recipe.spirits), (App)Codec.BOOL.optionalFieldOf("carryOverComponentData", (Object)false).forGetter(recipe -> recipe.carryOverComponentData)).apply((Applicative)obj, SpiritInfusionRecipe::new));
    public static final String NAME = "spirit_infusion";
    public final SizedIngredient ingredient;
    public final ItemStack output;
    public final List<SizedIngredient> extraIngredients;
    public final List<SpiritIngredient> spirits;
    public final boolean carryOverComponentData;

    public SpiritInfusionRecipe(SizedIngredient ingredient, ItemStack output, List<SizedIngredient> extraIngredients, List<SpiritIngredient> spirits, boolean carryOverComponentData) {
        super((RecipeSerializer)MalumRecipeSerializers.INFUSION_RECIPE_SERIALIZER.get(), (RecipeType)MalumRecipeTypes.SPIRIT_INFUSION.get());
        this.ingredient = ingredient;
        this.output = output;
        this.extraIngredients = extraIngredients;
        this.spirits = spirits;
        this.carryOverComponentData = carryOverComponentData;
    }

    public boolean matches(SpiritBasedRecipeInput input, Level level) {
        return input.test(this.ingredient, this.spirits);
    }

    public ItemStack getOutput(ServerLevel level, ItemStack input) {
        ItemStack outputStack = this.output.copy();
        if (this.carryOverComponentData) {
            ArrayList<DataComponentType> toCopy = new ArrayList<DataComponentType>();
            for (TypedDataComponent component : input.getComponents()) {
                ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)component.type());
                if (key == null) {
                    throw new IllegalArgumentException("Data component type " + String.valueOf(component.type()) + " is not registered, somehow.");
                }
                Holder holder = (Holder)BuiltInRegistries.DATA_COMPONENT_TYPE.getHolder(key).orElseThrow();
                if (holder.is(MalumTags.DataComponentTags.SPIRIT_INFUSION_BLACKLIST)) continue;
                toCopy.add(component.type());
            }
            for (DataComponentType dataComponentType : toCopy) {
                if (dataComponentType.equals((Object)DataComponents.ENCHANTMENTS)) {
                    HolderLookup.RegistryLookup lookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                    ItemEnchantments inputEnchantments = input.getAllEnchantments(lookup);
                    for (Object2IntMap.Entry entry : inputEnchantments.entrySet()) {
                        Holder enchantment = (Holder)entry.getKey();
                        int enchantmentLevel = entry.getIntValue();
                        if (!outputStack.supportsEnchantment(enchantment)) continue;
                        outputStack.enchant(enchantment, enchantmentLevel);
                    }
                    continue;
                }
                outputStack.copyFrom((DataComponentHolder)input, new DataComponentType[]{dataComponentType});
            }
        }
        return outputStack;
    }
}

