/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.neoforged.neoforge.registries.DeferredHolder;

public class PotionRiteEffect
extends TotemicRiteEffect {
    public final MalumSpiritType definingSpirit;
    public final Class<? extends LivingEntity> targetClass;
    public final DeferredHolder<MobEffect, MobEffect> mobEffectHolder;

    public PotionRiteEffect(MalumSpiritType definingSpirit, Class<? extends LivingEntity> targetClass, DeferredHolder<MobEffect, MobEffect> mobEffectSupplier) {
        super(TotemicRiteEffect.MalumRiteEffectCategory.AURA);
        this.definingSpirit = definingSpirit;
        this.targetClass = targetClass;
        this.mobEffectHolder = mobEffectSupplier;
    }

    @Override
    public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
        this.getNearbyEntities(totemBase, this.targetClass).filter(this.getEntityPredicate()).forEach(e -> {
            MobEffectInstance instance = new MobEffectInstance(this.mobEffectHolder, 1200, 1, true, true);
            boolean success = e.addEffect(instance);
            if (!e.hasEffect(instance.getEffect()) && success) {
                MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(this.definingSpirit).spawn(level);
            }
        });
    }

    public Predicate<LivingEntity> getEntityPredicate() {
        return e -> !(e instanceof Monster);
    }
}

