/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EldritchAqueousRiteType
extends TotemicRiteType {
    public EldritchAqueousRiteType() {
        super("greater_aqueous_rite", MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyBlocks(totemBase, PointedDripstoneBlock.class).forEach(p -> {
                    if (level.random.nextFloat() < 0.1f) {
                        MalumParticleEffectTypes.BLOCK_FALL_RITE_EFFECT.createEffect((BlockPos)p).color(MalumSpiritTypes.AQUEOUS_SPIRIT).spawn(level);
                        for (int i = 0; i < 4 + level.random.nextInt(2); ++i) {
                            level.getBlockState(p).randomTick(level, p, level.random);
                        }
                    }
                });
            }

            @Override
            public boolean canAffectBlock(TotemBaseBlockEntity totemBase, BlockState state, BlockPos pos) {
                return super.canAffectBlock(totemBase, state, pos) && PointedDripstoneBlock.isStalactiteStartPos((BlockState)state, (LevelReader)totemBase.getLevel(), (BlockPos)pos);
            }

            @Override
            public int getRiteEffectVerticalRadius() {
                return 4;
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, Zombie.class).filter(z -> !(z instanceof Drowned)).forEach(e -> {
                    if (!e.isUnderWaterConverting()) {
                        e.startUnderWaterConversion(100);
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(MalumSpiritTypes.AQUEOUS_SPIRIT).spawn(level);
                    }
                });
            }
        };
    }
}

