/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class EldritchWickedRiteType
extends TotemicRiteType {
    public EldritchWickedRiteType() {
        super("greater_wicked_rite", MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> !(e instanceof Player)).forEach(e -> {
                    if (e.getHealth() <= 2.5f && !e.isInvulnerableTo(DamageTypeHelper.create((Level)e.level(), MalumDamageTypes.VOODOO_PLAYERLESS))) {
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(MalumSpiritTypes.WICKED_SPIRIT).spawn(level);
                        e.hurt(DamageTypeHelper.create((Level)e.level(), MalumDamageTypes.VOODOO_PLAYERLESS), 10.0f);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                DamageSource damageSource = DamageTypeHelper.create((Level)level, MalumDamageTypes.VOODOO_PLAYERLESS);
                Map<Class, List<Animal>> animalMap = this.getNearbyEntities(totemBase, Animal.class, e -> e.getAge() >= 0 && !e.isInvulnerableTo(damageSource)).collect(Collectors.groupingBy(Object::getClass));
                block0: for (List<Animal> animals : animalMap.values()) {
                    if (animals.size() < 20) continue;
                    int maxKills = animals.size() - 20;
                    for (Animal animal : animals) {
                        if (animal.isInLove()) continue;
                        animal.hurt(damageSource, animal.getMaxHealth());
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)animal).color(MalumSpiritTypes.WICKED_SPIRIT).spawn(level);
                        if (maxKills-- > 0) continue;
                        continue block0;
                    }
                }
            }
        };
    }
}

