/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldevent;

import com.sammy.malum.common.worldgen.blight.BlightFeature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public abstract class ActiveBlightWorldEvent
extends WorldEventInstance {
    protected List<Integer> intensity = new ArrayList<Integer>();
    protected int frequency;
    protected int delay;
    protected int timer;
    protected BlockPos position;

    public ActiveBlightWorldEvent(WorldEventType type) {
        super(type);
    }

    public ActiveBlightWorldEvent setData(List<Integer> intensity, int frequency, int delay) {
        this.intensity.addAll(intensity);
        this.frequency = frequency;
        this.delay = delay;
        return this;
    }

    public ActiveBlightWorldEvent setPosition(BlockPos position) {
        this.position = position;
        return this;
    }

    public void tick(Level level) {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (this.timer == 0) {
            this.timer = this.frequency;
            if (this.intensity.isEmpty()) {
                this.end(level);
                return;
            }
            this.createBlight((ServerLevel)level, this.intensity.removeFirst());
        }
        --this.timer;
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("timer", this.timer);
        compoundTag.putInt("frequency", this.frequency);
        compoundTag.putInt("delay", this.delay);
        compoundTag.put("position", NbtUtils.writeBlockPos((BlockPos)this.position));
        ListTag intensityList = new ListTag();
        for (Integer i : this.intensity) {
            intensityList.add((Object)IntTag.valueOf((int)i));
        }
        compoundTag.put("intensity", (Tag)intensityList);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.timer = compoundTag.getInt("timer");
        this.frequency = compoundTag.getInt("frequency");
        this.delay = compoundTag.getInt("delay");
        this.position = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compoundTag, (String)"position").orElseThrow();
        this.intensity.clear();
        ListTag intensityList = compoundTag.getList("intensity", 3);
        for (int i = 0; i < intensityList.size(); ++i) {
            this.intensity.add(intensityList.getInt(i));
        }
    }

    public void createBlight(ServerLevel level, int intensity) {
        BlightFeature.generateBlight((WorldGenLevel)level, this.position, false, intensity).place((WorldGenLevel)level);
    }
}

