/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HiddenRecipeSet<T> {
    private final RecipeType<T> recipeType;
    private final Set<T> hiddenRecipes = new HashSet<T>();

    public static HiddenRecipeSet<?> createSet(RecipeType<?> recipeType) {
        return new HiddenRecipeSet(recipeType);
    }

    public HiddenRecipeSet(RecipeType<T> recipeType) {
        this.recipeType = recipeType;
    }

    public void unhidePreviouslyHiddenRecipes(IRecipeManager manager) {
        manager.unhideRecipes(this.recipeType, this.hiddenRecipes);
        this.hiddenRecipes.clear();
    }

    public void scanAndHideRecipes(IRecipeManager manager, IFocusFactory focusFactory, Collection<TagKey<Item>> nowHidden) {
        List foci = nowHidden.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getTag(arg_0)).filter(Optional::isPresent).map(o -> ((HolderSet.Named)o.get()).contents).flatMap(Collection::stream).map(Holder::value).distinct().flatMap(item -> {
            ItemStack stack = item.getDefaultInstance();
            IFocus asIngredient = focusFactory.createFocus(RecipeIngredientRole.INPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            IFocus asResult = focusFactory.createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            IFocus asCatalyst = focusFactory.createFocus(RecipeIngredientRole.CATALYST, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            return Stream.of(asIngredient, asResult, asCatalyst);
        }).toList();
        manager.createRecipeLookup(this.recipeType).limitFocus(foci).get().forEach(this.hiddenRecipes::add);
        manager.hideRecipes(this.recipeType, this.hiddenRecipes);
    }
}

