/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.datafixers.util.Pair;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.MalignantInfluenceData;
import com.sammy.malum.core.listeners.MalignantConversionReloadListener;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MalignantConversionHandler {
    public static final ResourceLocation NEGATIVE_MODIFIER_ID = MalumMod.malumPath("malignant_conversion_tally");
    public static final HashMap<Holder<Attribute>, ResourceLocation> POSITIVE_MODIFIER_IDS = new HashMap();

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!livingEntity.level().isClientSide) {
                MalignantInfluenceData data = (MalignantInfluenceData)livingEntity.getData(MalumAttachmentTypes.MALIGNANT_INFLUENCE);
                DeferredHolder<Attribute, Attribute> conversionAttribute = MalumAttributes.MALIGNANT_CONVERSION;
                AttributeInstance conversionInstance = livingEntity.getAttribute(conversionAttribute);
                if (conversionInstance != null) {
                    if (data.skipConversionLogic) {
                        if (conversionInstance.getValue() == 0.0) {
                            return;
                        }
                        data.skipConversionLogic = false;
                    }
                    Collection<MalignantConversionReloadListener.MalignantConversionData> values = MalignantConversionReloadListener.CONVERSION_DATA.values();
                    for (MalignantConversionReloadListener.MalignantConversionData conversionData : values) {
                        Holder<Attribute> attribute = conversionData.sourceAttribute();
                        AttributeInstance instance = livingEntity.getAttribute(attribute);
                        if (instance == null || !data.cachedAttributeValues.containsKey(attribute)) continue;
                        MalignantConversionHandler.convertAttribute(data, livingEntity, conversionData.sourceAttribute(), conversionData.consumptionRatio(), conversionData.ignoreBaseValue(), conversionData.targetAttributes(), false);
                    }
                    if (data.cachedAttributeValues.containsKey(conversionAttribute) && data.cachedAttributeValues.get(conversionAttribute).doubleValue() != conversionInstance.getValue()) {
                        for (MalignantConversionReloadListener.MalignantConversionData conversionData : values) {
                            MalignantConversionHandler.convertAttribute(data, livingEntity, conversionData.sourceAttribute(), conversionData.consumptionRatio(), conversionData.ignoreBaseValue(), conversionData.targetAttributes(), true);
                        }
                    }
                    data.cachedAttributeValues.put((Holder<Attribute>)conversionAttribute, conversionInstance.getValue());
                    if (conversionInstance.getValue() == 0.0) {
                        data.skipConversionLogic = true;
                    }
                }
            }
        }
    }

    private static void convertAttribute(MalignantInfluenceData data, LivingEntity livingEntity, Holder<Attribute> sourceAttribute, double consumptionRatio, boolean ignoreBaseValue, List<Pair<Holder<Attribute>, Double>> targetAttributes, boolean skipCacheComparison) {
        AttributeMap attributes = livingEntity.getAttributes();
        double malignantConversion = attributes.getValue(MalumAttributes.MALIGNANT_CONVERSION);
        AttributeInstance sourceInstance = livingEntity.getAttribute(sourceAttribute);
        if (sourceInstance != null) {
            boolean hasMalignantConversion;
            AttributeModifier originalModifier = sourceInstance.getModifier(NEGATIVE_MODIFIER_ID);
            if (originalModifier != null) {
                sourceInstance.removeModifier(originalModifier);
            }
            boolean bl = hasMalignantConversion = malignantConversion > 0.0;
            if (skipCacheComparison || data.cachedAttributeValues.get(sourceAttribute).doubleValue() != sourceInstance.getValue()) {
                double cachedValue = sourceInstance.getValue() - (ignoreBaseValue ? sourceInstance.getBaseValue() : 0.0);
                for (Pair<Holder<Attribute>, Double> target : targetAttributes) {
                    Holder targetAttribute = (Holder)target.getFirst();
                    AttributeInstance targetInstance = livingEntity.getAttribute(targetAttribute);
                    if (targetInstance == null) continue;
                    ResourceLocation id = POSITIVE_MODIFIER_IDS.computeIfAbsent(sourceAttribute, MalignantConversionHandler::createPositiveModifierId);
                    targetInstance.removeModifier(id);
                    double bonus = cachedValue * malignantConversion * (Double)target.getSecond();
                    if (!(bonus > 0.0)) continue;
                    AttributeModifier modifier = new AttributeModifier(id, bonus, AttributeModifier.Operation.ADD_VALUE);
                    targetInstance.addTransientModifier(modifier);
                }
                data.cachedAttributeValues.put(sourceAttribute, sourceInstance.getValue());
                if (hasMalignantConversion) {
                    double negativeOffset = -malignantConversion * consumptionRatio;
                    AttributeModifier modifier = new AttributeModifier(NEGATIVE_MODIFIER_ID, negativeOffset, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
                    sourceInstance.addTransientModifier(modifier);
                }
            }
            if (originalModifier != null && sourceInstance.getModifier(NEGATIVE_MODIFIER_ID) == null && hasMalignantConversion) {
                sourceInstance.addTransientModifier(originalModifier);
            }
        }
    }

    private static ResourceLocation createPositiveModifierId(Holder<Attribute> attribute) {
        return MalumMod.malumPath("malignant_conversion_buff_from_" + BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)attribute.value())).getPath());
    }
}

