/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.common.data.attachment.TouchOfDarknessData;
import com.sammy.malum.registry.client.MalumShaders;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import java.util.function.Consumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class TouchOfDarknessRenderHandler {
    public static void renderDarknessVignette(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        LocalPlayer player = minecraft.player;
        TouchOfDarknessData data = (TouchOfDarknessData)player.getData(MalumAttachmentTypes.TOUCH_OF_DARKNESS);
        if (data.touchOfDarkness == 0.0f) {
            return;
        }
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        float effectStrength = Easing.SINE_IN_OUT.ease(data.touchOfDarkness / 100.0f, 0.0f, 1.0f, 1.0f);
        float alpha = Math.min(1.0f, effectStrength * 5.0f);
        float zoom = 0.5f + Math.min(0.35f, effectStrength);
        float intensity = 1.0f + (effectStrength > 0.5f ? (effectStrength - 0.5f) * 2.5f : 0.0f);
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)MalumShaders.TOUCH_OF_DARKNESS.getInstance().get();
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        Consumer<Float> setZoom = f -> shaderInstance.safeGetUniform("Zoom").set(f.floatValue());
        Consumer<Float> setIntensity = f -> shaderInstance.safeGetUniform("Intensity").set(f.floatValue());
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPositionWithWidth((float)screenWidth * -0.2f, (float)screenHeight * -0.2f, (float)screenWidth * 1.4f, (float)screenHeight * 1.4f).setAlpha(alpha).setShader((ShaderInstance)shaderInstance);
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < 4; ++i) {
            poseStack.pushPose();
            if (i != 3) {
                float angle = (((float)player.level().getGameTime() + deltaTracker.getGameTimeDeltaTicks()) / 80.0f + (float)i * 2.09f) * 6.28f;
                float xOffset = Mth.sin((float)angle) * 20.0f;
                float yOffset = Mth.cos((float)angle) * 20.0f;
                poseStack.translate(xOffset, yOffset, 0.0f);
                RenderSystem.blendFunc((int)770, (int)1);
            } else {
                RenderSystem.defaultBlendFunc();
            }
            float color = 0.06f;
            builder.setColor(i == 0 ? 0.06f : 0.0f, i == 1 ? 0.06f : 0.0f, i == 2 ? 0.06f : 0.0f);
            setZoom.accept(Float.valueOf(zoom));
            setIntensity.accept(Float.valueOf(intensity));
            builder.setAlpha(alpha).blit(poseStack);
            setZoom.accept(Float.valueOf(zoom * 1.25f + 0.15f));
            setIntensity.accept(Float.valueOf(intensity * 0.8f + 0.5f));
            builder.setAlpha(0.5f * alpha).blit(poseStack);
            poseStack.popPose();
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
        shaderInstance.setUniformDefaults();
    }
}

