/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.enchantment;

import com.sammy.malum.common.item.curiosities.curios.sets.scythe.CurioRisingEdgeRing;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.enchantment.EnchantmentKeys;
import com.sammy.malum.registry.common.item.MalumItems;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;

public class AscensionHandler {
    public static void triggerAscension(Level level, Player player, InteractionHand hand, ItemStack scythe) {
        int enchantmentLevel;
        int cooldown;
        boolean isEnhanced = MalumScytheItem.isEnhanced((LivingEntity)player);
        player.resetFallDistance();
        if (level.isClientSide()) {
            Vec3 motion = player.getDeltaMovement();
            player.setDeltaMovement(motion.x, (double)(player.getJumpPower() * 2.0f), motion.z);
            if (player.isSprinting()) {
                float f = player.getYRot() * ((float)Math.PI / 180);
                float x = -Mth.sin((float)f);
                float z = Mth.cos((float)f);
                Vec3 newMotion = player.getDeltaMovement();
                newMotion = isEnhanced ? newMotion.subtract((double)(x * 0.4f), 0.0, (double)(z * 0.4f)) : newMotion.add((double)(x * 0.75f), 0.0, (double)(z * 0.75f));
                player.setDeltaMovement(newMotion);
            }
            player.hasImpulse = true;
            CommonHooks.onLivingJump((LivingEntity)player);
        }
        boolean hasFunnyRing = CurioHelper.hasCurioEquipped((LivingEntity)player, (Item)((Item)MalumItems.RING_OF_THE_RISING_EDGE.get()));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.getRandom();
            float baseDamage = (float)player.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
            float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
            AABB aabb = player.getBoundingBox().inflate(4.0, 1.0, 4.0);
            SoundEvent sound = (SoundEvent)MalumSoundEvents.SCYTHE_SWEEP.get();
            WeaponParticleEffectType.WeaponParticleEffectBuilder particle = MalumParticleEffectTypes.SCYTHE_ASCENSION_SPIN.createEffect((Entity)player).mirroredRandomly(random);
            if (isEnhanced) {
                baseDamage *= 1.3f;
                magicDamage *= 1.3f;
                aabb = aabb.move(player.getLookAngle().scale(2.0)).inflate(-2.0, 1.0, -2.0);
                sound = (SoundEvent)MalumSoundEvents.SCYTHE_CUT.get();
                particle = MalumParticleEffectTypes.SCYTHE_ASCENSION_UPPERCUT.createEffect().verticalSlashRotation().mirroredRandomly(random).mirrored().forwardOffset(0.8f);
            }
            if (hasFunnyRing) {
                baseDamage *= 0.5f;
                magicDamage *= 0.5f;
            }
            particle.color(scythe.getItem());
            boolean dealtDamage = false;
            for (Entity target : serverLevel.getEntities((Entity)player, aabb, t -> AscensionHandler.ascensionCanHitEntity(player, t))) {
                DamageSource damageSource = DamageTypeHelper.create((Level)serverLevel, MalumDamageTypes.SCYTHE_ASCENSION, (Entity)player);
                target.invulnerableTime = 0;
                boolean success = target.hurt(damageSource, baseDamage);
                if (!success || !(target instanceof LivingEntity)) continue;
                LivingEntity livingentity = (LivingEntity)target;
                if (magicDamage > 0.0f && !livingentity.isDeadOrDying()) {
                    livingentity.invulnerableTime = 0;
                    livingentity.hurt(DamageTypeHelper.create((Level)serverLevel, MalumDamageTypes.VOODOO, (Entity)player), magicDamage);
                }
                SoundHelper.playSound((Entity)player, (SoundEvent)sound, (float)2.0f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.25f));
                dealtDamage = true;
                if (!hasFunnyRing) continue;
                CurioRisingEdgeRing.launchEntity((LivingEntity)player, livingentity);
            }
            if (dealtDamage) {
                player.addEffect(new MobEffectInstance(MalumMobEffects.ASCENSION, 80, 0));
            }
            Vec3 slashPosition = player.position().add(0.0, (double)player.getBbHeight() * 0.75, 0.0);
            Vec3 slashDirection = player.getLookAngle().multiply(1.0, 0.0, 1.0);
            particle.at(slashPosition).aimedAt(slashDirection).spawn(serverLevel);
            for (int i = 0; i < 3; ++i) {
                SoundHelper.playSound((Entity)player, (SoundEvent)sound, (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)random, (float)1.25f, (float)1.75f));
            }
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_ASCENSION.get()), (float)2.0f, (float)RandomHelper.randomBetween((RandomSource)random, (float)1.25f, (float)1.5f));
        }
        if (!player.isCreative() && (cooldown = 200 - 40 * ((enchantmentLevel = EnchantmentKeys.getEnchantmentLevel(level, EnchantmentKeys.ASCENSION, scythe)) - 1)) > 0) {
            player.getCooldowns().addCooldown(scythe.getItem(), cooldown);
        }
        player.swing(hand, false);
        player.awardStat(Stats.ITEM_USED.get((Object)scythe.getItem()));
    }

    protected static boolean ascensionCanHitEntity(Player attacker, Entity pTarget) {
        TamableAnimal tamableAnimal;
        if (pTarget instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)pTarget).isTame()) {
            return false;
        }
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        return pTarget != attacker && !attacker.isPassengerOfSameVehicle(pTarget);
    }
}

