/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.mana_mote.ManaMoteBlock;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.SpiritTypeBuilder;
import com.sammy.malum.core.systems.spirit.SpiritVisualMotif;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.block.MalumBlocks;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public class MalumSpiritType {
    public static final Codec<MalumSpiritType> CODEC = Codec.STRING.comapFlatMap(s -> {
        MalumSpiritType spiritType = MalumSpiritTypes.SPIRITS.get(s);
        if (spiritType == null) {
            throw new JsonParseException("No Such Spirit Type: " + s);
        }
        return DataResult.success((Object)spiritType);
    }, MalumSpiritType::getIdentifier);
    public static StreamCodec<ByteBuf, MalumSpiritType> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    protected final String identifier;
    protected final Supplier<SpiritShardItem> spiritShard;
    private final SpiritVisualMotif visualMotif;
    protected Rarity itemRarity;
    protected Component spiritItemDescription;

    public static SpiritTypeBuilder create(String identifier, SpiritVisualMotif visualMotif, Supplier<SpiritShardItem> spiritShard) {
        return new SpiritTypeBuilder(identifier, visualMotif, spiritShard);
    }

    public MalumSpiritType(String identifier, Supplier<SpiritShardItem> spiritShard, SpiritVisualMotif visualMotif) {
        this.identifier = identifier;
        this.spiritShard = spiritShard;
        this.visualMotif = visualMotif;
    }

    public static MalumSpiritType getSpiritType(String spirit) {
        return MalumSpiritTypes.SPIRITS.getOrDefault(spirit, MalumSpiritTypes.SACRED_SPIRIT);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public SpiritShardItem getSpiritShard() {
        return this.spiritShard.get();
    }

    public boolean test(ItemStack stack) {
        return stack.getItem().equals((Object)this.getSpiritShard());
    }

    public float getAlphaMultiplier() {
        return this.visualMotif.getAlphaMultiplier();
    }

    public Color getPrimaryColor() {
        return this.visualMotif.getPrimaryColor();
    }

    public Color getSecondaryColor() {
        return this.visualMotif.getSecondaryColor();
    }

    public float getColorCoefficient() {
        return this.visualMotif.getColorCoefficient();
    }

    public ColorParticleDataBuilder createColorData() {
        return this.createColorData(1.0f);
    }

    public ColorParticleDataBuilder createColorData(float coefficientMultiplier) {
        return this.visualMotif.createColorData(coefficientMultiplier);
    }

    public Color getItemColor() {
        return this.visualMotif.itemColor;
    }

    public TextColor getTextColor(boolean isTooltip) {
        Color color = isTooltip ? ColorHelper.darker((Color)this.getPrimaryColor(), (int)1, (float)0.75f) : ColorHelper.brighter((Color)this.getPrimaryColor(), (int)1, (float)0.85f);
        return TextColor.fromRgb((int)color.getRGB());
    }

    public Rarity getItemRarity() {
        if (this.itemRarity == null) {
            TextColor textColor = this.getTextColor(false);
            this.itemRarity = Rarity.UNCOMMON;
        }
        return this.itemRarity;
    }

    public Component getSpiritShardFlavourTextComponent() {
        if (this.spiritItemDescription == null) {
            this.spiritItemDescription = Component.translatable((String)this.getSpiritFlavourText()).withStyle(ChatFormatting.ITALIC).withStyle(Style.EMPTY.withColor(this.getTextColor(true)));
        }
        return this.spiritItemDescription;
    }

    public String getSpiritFlavourText() {
        return "malum.spirit.flavour." + this.identifier;
    }

    public Component getSpiritJarCounterComponent(int count) {
        return Component.literal((String)(" " + count + " ")).append((Component)Component.translatable((String)this.getSpiritDescription())).withStyle(Style.EMPTY.withColor(this.getPrimaryColor().getRGB()));
    }

    public String getSpiritDescription() {
        return "malum.spirit.description." + this.identifier;
    }

    public ResourceLocation getTotemGlowTexture() {
        return MalumMod.malumPath("textures/vfx/totem_poles/" + this.identifier + "_glow.png");
    }

    public BlockState getTotemPoleBlockState(boolean isCorrupt, BlockHitResult hit) {
        Block base = isCorrupt ? (Block)MalumBlocks.SOULWOOD_TOTEM_POLE.get() : (Block)MalumBlocks.RUNEWOOD_TOTEM_POLE.get();
        return (BlockState)((BlockState)base.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)hit.getDirection())).setValue((Property)MalumSpiritTypes.SPIRIT_TYPE_PROPERTY, (Comparable)((Object)this.identifier));
    }

    public BlockState getSpiritMoteBlockState() {
        return (BlockState)((Block)MalumBlocks.SPIRIT_MOTE.get()).defaultBlockState().setValue((Property)ManaMoteBlock.SPIRIT_TYPE, (Comparable)((Object)this.identifier));
    }
}

