/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.lang;

import com.sammy.malum.common.block.ether.EtherWallTorchBlock;
import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.compability.create.CreateCompat;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.datagen.lang.CodexLangDatagen;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritRiteTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.enchantment.EnchantmentKeys;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.DataHelper;

public class MalumLang
extends LanguageProvider {
    public static MalumLang lang;

    public MalumLang(PackOutput gen) {
        super(gen, "malum", "en_us");
        lang = this;
    }

    protected void addTranslations() {
        CodexLangDatagen.generateEntries();
        HashSet blocks = new HashSet(MalumBlocks.BLOCKS.getEntries());
        HashSet items = new HashSet(MalumItems.ITEMS.getEntries());
        HashSet sounds = new HashSet(MalumSoundEvents.SOUNDS.getEntries());
        HashSet effects = new HashSet(MalumMobEffects.EFFECTS.getEntries());
        HashSet attributes = new HashSet(MalumAttributes.ATTRIBUTES.getEntries());
        HashSet entities = new HashSet(MalumEntities.ENTITY_TYPES.getEntries());
        this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.PRIMORDIAL_SOUP)).get(), "The Weeping Well");
        this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.VOID_CONDUIT)).get(), "The Weeping Well");
        this.add("item.malum.filled_spirit_jar", "Filled Spirit Jar");
        this.add("malum.spirit.description.stored_spirit", "Contains: ");
        this.add("malum.spirit.description.stored_soul", "Stores Soul With: ");
        if (CreateCompat.LOADED) {
            this.add("item.malum.copper_nugget", "Copper Nugget");
        }
        DataHelper.takeAll(blocks, i -> i.get() instanceof WallTorchBlock);
        DataHelper.takeAll(blocks, i -> i.get() instanceof EtherWallTorchBlock);
        DataHelper.takeAll(blocks, i -> i.get() instanceof WallSignBlock);
        blocks.forEach(b -> {
            String name = ((Block)b.get()).getDescriptionId().replaceFirst("block\\.malum\\.", "");
            name = this.makeProper(DataHelper.toTitleCase((String)this.correctItemName(name), (String)"_"));
            this.add(((Block)b.get()).getDescriptionId(), name);
        });
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && !(i.get() instanceof ItemNameBlockItem));
        items.forEach(i -> {
            String name = ((Item)i.get()).getDescriptionId().replaceFirst("item\\.malum\\.", "");
            name = this.makeProper(DataHelper.toTitleCase((String)this.correctItemName(name), (String)"_"));
            this.add(((Item)i.get()).getDescriptionId(), name);
        });
        sounds.forEach(s -> {
            Object name = this.correctSoundName(s.getId().getPath()).replaceAll("_", " ");
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
            this.add("malum.subtitle." + s.getId().getPath(), (String)name);
        });
        effects.forEach(e -> {
            String name = DataHelper.toTitleCase((String)this.makeProperEnglish(e.getId().getPath()), (String)"_");
            this.add("effect.malum." + BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)e.get())).getPath(), name);
        });
        attributes.forEach(a -> {
            String name = DataHelper.toTitleCase((String)a.getId().getPath(), (String)"_");
            this.add("attribute.name.malum." + BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)a.get())).getPath(), name);
        });
        entities.forEach(e -> {
            String name = DataHelper.toTitleCase((String)e.getId().getPath(), (String)"_");
            this.add("entity.malum." + BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)e.get())).getPath(), name);
        });
        for (MalumSpiritType spirit : MalumSpiritTypes.SPIRITS.values()) {
            this.add(spirit.getSpiritDescription(), DataHelper.toTitleCase((String)(spirit.getIdentifier() + "_spirit"), (String)"_"));
        }
        for (SoulwovenBannerPatternDataComponent pattern : SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS) {
            this.add(pattern.translationKey(), DataHelper.toTitleCase((String)pattern.type().getPath(), (String)"_"));
        }
        for (ArtificeAttributeType attribute : ArtificeAttributeType.CRUCIBLE_ATTRIBUTES) {
            this.add(attribute.getLangKey(), DataHelper.toTitleCase((String)attribute.id.getPath().toLowerCase(Locale.ROOT), (String)"_"));
        }
        for (DeferredHolder geas : MalumGeasEffectTypes.GEAS_TYPES.getEntries()) {
            GeasEffectType effectType = (GeasEffectType)geas.get();
            this.add(effectType.getLangKey(), DataHelper.toTitleCase((String)geas.getId().getPath().toLowerCase(Locale.ROOT), (String)"_"));
        }
        this.add("malum.gui.slot", "Slot: ");
        this.add("malum.gui.augment.installed", "When installed: ");
        this.add("malum.gui.augment.type.augment", "Augment");
        this.add("malum.gui.augment.type.core_augment", "Core Augment");
        this.add("malum.gui.rite.type", "Type: ");
        this.add("malum.gui.rite.medium", "Medium: ");
        this.add("malum.gui.rite.medium.runewood", "Runewood");
        this.add("malum.gui.rite.medium.soulwood", "Soulwood");
        this.add("malum.gui.rite.coverage", "Coverage: ");
        this.add("malum.gui.rite.effect", "Effect: ");
        this.add("malum.gui.geas.type", "Geas");
        this.add("malum.gui.geas.sworn", "When Sworn: ");
        this.add("malum.gui.geas.creative", "Creative Item for Debug Purposes.");
        this.add("malum.gui.geas.creative_help", "Use To Swear/Forswear Geas Effect.");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_DEFIANCE.get(), "Rage, rage, against the dying of your might");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PARASITE.get(), "Why work for what others have");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_LIFEWEAVER.get(), "Weave your life into miracles");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_WARLOCK.get(), "Weave the arcane");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_REAPER.get(), "Swear loyalty to the edge");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_BERSERKER.get(), "Your pain, their pain");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_FORTRESS.get(), "Be strong when you are needed");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_SHIELD.get(), "Always be ready to stand and fight");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_RECIPROCATION.get(), "Prove your strength by wielding it");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_SHATTERING_ADDICT.get(), "Claim what you want, and never stop");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_ARCANAPHAGE.get(), "Seek magic in any form");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_RUNE_EXPLOITATION.get(), "Gather them all, exhaust every possibility");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_SELF_CARE.get(), "Eat, lest your body consume itself");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_HIGH_PRIEST.get(), "Become what they believe, so long as they believe");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_TIDAL_AFFINITY.get(), "Become the ocean's avatar");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_PATIENCE_REPAID.get(), "A warped echo");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_WINDSWEPT.get(), "Run as the wind");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_CONTINUING_SHOT.get(), "Step. Form. Ready. Raise. Begin. Draw. Release.");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_CLOUDSKIPPER.get(), "Dance along the edge of danger");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_SKYBREAKER.get(), "Move and be moved");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_CONTENTEDNESS.get(), "To be full is to be anchored");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_LONE_DRUID.get(), "Shed your second skin");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PROFANE_ASCETIC.get(), "Forswear indulgence, and be healed by rot");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PROFANE_GLUTTON.get(), "Consume.");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_FLAMEKEEPER.get(), "Care for the flame");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_COMBUSTION.get(), "Set yourself ablaze, figuratively");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PYROMANIAC.get(), "Draw power from recklessness");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.PACT_OF_WYRD_RECONSTRUCTION.get(), "Witness oblivion and forge yourself anew");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.OATH_OF_THE_OVERKEEN_EYE.get(), "Measure twice, cut once");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.OATH_OF_THE_OVERBURDENED_MIND.get(), "Measure carefully, cut later");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.OATH_OF_THE_OVEREAGER_FIST.get(), "Cut twice, never measure");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.OATH_OF_UNMAKERS_DISDAIN.get(), "Acknowledge no one, and be acknowledged by none");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.OATH_OF_UNSIGHTED_RESISTANCE.get(), "See no evil, feel no evil");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.OATH_OF_THE_UNDISCERNED_MAW.get(), "Take the life of your enemies");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.AUTHORITY_OF_THE_INVERTED_HEART.get(), "Your heart is the world, and the world beats");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.AUTHORITY_OF_THE_GLEEFUL_TARGET.get(), "Take it all, let it never stop, more, and more, and more");
        this.addGeasDescription((GeasEffectType)MalumGeasEffectTypes.CREED_OF_THE_BLIGHT_EATER.get(), "Mmmm... Blight... So Tasty..");
        this.add("malum.waveform_artifice.wavecharger", "Redstone Easing Duration");
        this.add("malum.waveform_artifice.wavebanker", "Redstone Pulse Duration");
        this.add("malum.waveform_artifice.wavemaker", "Redstone Pulse Interval");
        this.add("malum.waveform_artifice.wavebreaker", "Redstone Pulse Delay");
        this.add("malum.waveform_artifice.value_display", ": %1$s %2$s");
        this.add("malum.waveform_artifice.redstone_ticks", "Redstone Ticks");
        this.add("malum.waveform_artifice.seconds", "Seconds");
        this.add("malum.waveform_artifice.minutes", "Minutes");
        this.add("malum.waveform_artifice.guide.2", "Scroll To Fine Tune Value");
        this.add("malum.waveform_artifice.guide.1", "Use Left Button To Modify Unit Type");
        this.add("malum.waveform_artifice.guide.0", "Release Right Button To Confirm");
        this.addRiteEffectCategory(TotemicRiteEffect.MalumRiteEffectCategory.AURA);
        this.addRiteEffectCategory(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT);
        this.addRiteEffectCategory(TotemicRiteEffect.MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT);
        this.addRiteEffectCategory(TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT);
        this.addRiteEffectCategory(TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT);
        this.addRite(MalumSpiritRiteTypes.SACRED_RITE, "Rite of Healing", "Rite of Nourishment");
        this.addRite(MalumSpiritRiteTypes.WICKED_RITE, "Rite of Decay", "Rite of Empowerment");
        this.addRite(MalumSpiritRiteTypes.EARTHEN_RITE, "Rite of Warding", "Rite of the Arena");
        this.addRite(MalumSpiritRiteTypes.INFERNAL_RITE, "Rite of Haste", "Rite of the Hells");
        this.addRite(MalumSpiritRiteTypes.AERIAL_RITE, "Rite of Motion", "Rite of the Aether");
        this.addRite(MalumSpiritRiteTypes.AQUEOUS_RITE, "Rite of Loyalty", "Rite of the Seas");
        this.addRite(MalumSpiritRiteTypes.ARCANE_RITE, "Undirected Rite", "Unchained Rite");
        this.addRite(MalumSpiritRiteTypes.ELDRITCH_SACRED_RITE, "Rite of Growth", "Rite of Lust");
        this.addRite(MalumSpiritRiteTypes.ELDRITCH_WICKED_RITE, "Rite of Exorcism", "Rite of Culling");
        this.addRite(MalumSpiritRiteTypes.ELDRITCH_EARTHEN_RITE, "Rite of Destruction", "Rite of Shaping");
        this.addRite(MalumSpiritRiteTypes.ELDRITCH_INFERNAL_RITE, "Rite of Smelting", "Rite of Quickening");
        this.addRite(MalumSpiritRiteTypes.ELDRITCH_AERIAL_RITE, "Rite of Gravity", "Rite of Unwinding");
        this.addRite(MalumSpiritRiteTypes.ELDRITCH_AQUEOUS_RITE, "Rite of Sapping", "Rite of Drowning");
        this.add("malum.gui.ritual.type", "Ritual Type: ");
        this.add("malum.gui.ritual.tier", "Ritual Tier: ");
        this.add("jukebox_song.malum.arcane_elegy", "Kultik - Arcane Elegy");
        this.add("jukebox_song.malum.aesthetica", "Kultik - Aesthetica");
        this.add("curios.identifier.brooch", "Brooch");
        this.add("curios.modifiers.brooch", "When worn:");
        this.add("curios.identifier.rune", "Rune");
        this.add("curios.modifiers.rune", "When equipped:");
        this.add("malum.effect.positive", "+%s");
        this.add("malum.effect.negative", "-%s");
        this.addCurioEffect("scythe_execution", "Scythes Exploit Wounds");
        this.addCurioEffect("crits", "Critical Strikes");
        this.addCurioEffect("low_health_speed", "Speed at Low Health");
        this.addCurioEffect("shorten_negative_effect", "Shortens Negative Effects");
        this.addCurioEffect("burning_damage", "Burning Damage");
        this.addCurioEffect("scythe_chain", "Deadlier Scythe Sweeping");
        this.addCurioEffect("silence", "Silences Attackers");
        this.addCurioEffect("always_sprint", "Sprinting Always Available");
        this.addCurioEffect("extend_positive_effect", "Extends Positive Effects");
        this.addCurioEffect("burning_resistance", "Damage Resistance When Ablaze");
        this.addCurioEffect("totem_effect", "Grants %s");
        this.addCurioEffect("spirits_heal", "Spirit Collection Replenishes Health");
        this.addCurioEffect("spirits_xp", "Spirit Collection Generates Experience Points");
        this.addCurioEffect("spirits_extend_effect", "Spirit Collection Aids Potion Durations");
        this.addCurioEffect("spirits_weave_mana", "Spirit Collection Recovers Soul Ward");
        this.addCurioEffect("spirits_weave_mana_irons_spellbooks", "Spirit Collection Recovers Spell Mana [Iron's Spellbooks]");
        this.addCurioEffect("spirits_add_health", "Spirit Collection Grants Extra Hearts");
        this.addCurioEffect("spirits_weave_resonance", "Spirit Collection Generates Arcane Resonance");
        this.addCurioEffect("spirits_weave_resonance_irons_spellbooks", "Spirit Collection Reduces Spell Cooldown [Iron's Spellbooks]");
        this.addCurioEffect("hunger_drain", "Actively Drains Hunger");
        this.addCurioEffect("eat_rotten", "Rotten Foods are Tastier");
        this.addCurioEffect("growing_gluttony", "Eating Rotten Foods Extends Gluttony");
        this.addCurioEffect("explosion_drops_collected", "Automatic Collection of Explosion Drops");
        this.addCurioEffect("bigger_explosions", "Improves Explosions");
        this.addCurioEffect("no_sweep", "Disables Scythe Sweeping");
        this.addCurioEffect("enhanced_maneuvers", "Augments Rebound and Ascension");
        this.addCurioEffect("ascension_launch", "Ascension Launches Targets Upwards");
        this.addCurioEffect("lower_ascension_damage", "Ascension Suffers a Damage Penalty");
        this.addCurioEffect("rebound_maelstrom", "Rebound Creates A Windborne Maelstrom");
        this.addCurioEffect("longer_rebound_cooldown", "Rebound Suffers a Longer Cooldown");
        this.addCurioEffect("friendly_enemies", "Reduces Enemy Aggression");
        this.addCurioEffect("soul_ward_magic_resilience", "Soul Ward Reroutes Magic");
        this.addCurioEffect("soul_ward_long_shatter_cooldown", "Lengthy Soul Ward Recharge upon Disintegration");
        this.addCurioEffect("rotten_gluttony", "Eating Rotten Food Generates Gluttony");
        this.addCurioEffect("scythe_counterattack", "Powerful Scythe Counterattack When Struck");
        this.addCurioEffect("pacifist_recharge", "Cooldown Extends if the Scythe is Used");
        this.addCurioEffect("full_health_fake_collection", "Striking Full Health Targets Triggers Spirit Collection Effects");
        this.addCurioEffect("soul_ward_complete_absorption", "Soul Ward Absorbs All Damage");
        this.addCurioEffect("soul_ward_escalating_integrity", "Soul Ward Gains Integrity When Nearing Disintegration");
        this.addCurioEffect("spirits_gluttony", "Spirit Collection Generates Gluttony");
        this.addCurioEffect("enchanted_explosions", "Explosions are Enchanted with %s");
        this.addCurioEffect("explosions_spare_valuables", "Protects Valuable Items from Explosions");
        this.addGeasEffect("faster_natural_healing", "Saturation Heals Faster");
        this.addGeasEffect("spirits_absorption", "Spirit Collection Grants Absorption");
        this.addGeasEffect("passive_healing", "Passive Health Recovery");
        this.addGeasEffect("healing_aura", "Healing is Shared with Nearby Creatures");
        this.addGeasEffect("healing_aura_no_filter", "Shared Healing Heals All, Ally or Not");
        this.addGeasEffect("first_hit_bonus", "Blasts Healthy Enemies With Wicked Energy");
        this.addGeasEffect("aggressive_enemies", "Increases Enemy Aggression");
        this.addGeasEffect("scythe_combo", "Scythe Cuts Create Combo-Attacks");
        this.addGeasEffect("only_scythe", "Regular Weapons Crumble In Your Hands");
        this.addGeasEffect("damage_buildup", "Taking Damage Charges Up Wrath");
        this.addGeasEffect("damage_release", "Wrath Is Released When Striking A Target");
        this.addGeasEffect("more_damage", "All Incoming Damage Is Doubled");
        this.addGeasEffect("chained_spirit_bonus", "Repeated Soul Shatters Yield Extra Arcana");
        this.addGeasEffect("hunger_as_withdrawal", "Addiction to Slaughter");
        this.addGeasEffect("spirits_magic_boost", "Spirit Collection Amplifies Magic");
        this.addGeasEffect("oops_all_magic", "All Incoming Damage Functions As Magic");
        this.addGeasEffect("more_runes", "2 Rune Slots");
        this.addGeasEffect("rune_vulnerability", "Each Equipped Rune Dampens Healing, Armor and Magic Resistance");
        this.addGeasEffect("more_saturation", "Meals Provide Extra Saturation");
        this.addGeasEffect("food_effect_cleanse", "Eating Cleanses Negative Effects");
        this.addGeasEffect("faster_starving", "Starvation Occurs Faster");
        this.addGeasEffect("high_hunger_more_armor", "Being Well Fed Provides Extra Armor");
        this.addGeasEffect("low_hunger_less_armor", "Starvation Halves Armor");
        this.addGeasEffect("no_armor_armor", "The Absence of Equipped Armour Becomes Armor");
        this.addGeasEffect("no_armor", "Equipped Armour Damages You");
        this.addGeasEffect("bonus_reach", "Avoiding Harm Increases Reach");
        this.addGeasEffect("fragile_reach", "Reach Effect Faces Cooldown When Struck");
        this.addGeasEffect("fragile_reach_damage", "The High Priest's Rule Grips You Tightly");
        this.addGeasEffect("water_agility", "You Move and Swing Faster In Water");
        this.addGeasEffect("water_damage_resistance", "You Take Reduced Damage in Water");
        this.addGeasEffect("conduit_bonus", "Conduit Power Heals You And Amplifies Damage Reduction");
        this.addGeasEffect("fish_healing", "You Cannot Heal Outside Of Water");
        this.addGeasEffect("buffered_damage", "Half Of Incoming Damage Is Buffered");
        this.addGeasEffect("buffered_damage_non_lethal", "Buffered Damage Is Applied Overtime And Cannot Kill You");
        this.addGeasEffect("buffered_damage_more_overall", "Buffered Damage Is Amplified");
        this.addGeasEffect("movement_acceleration", "Sprinting Builds Up Extra Momentum");
        this.addGeasEffect("knockback_also_accelerates", "High Momentum Amplifies Received Knockback");
        this.addGeasEffect("faster_draw_time", "Successful Ranged Damage Builds Up Extra Draw Speed");
        this.addGeasEffect("missing_halts_draw_time", "Missing Inverts The Benefit");
        this.addGeasEffect("soul_ward_on_hit", "Magic Damage Recovers Soul Ward");
        this.addGeasEffect("incoming_fall_damage_auto_attack", "Taking Fall Damage Attacks Nearby Targets");
        this.addGeasEffect("outgoing_fall_damage_auto_attack", "Outgoing Fall Damage Attacks Targets Regardless Of Distance");
        this.addGeasEffect("more_knockback", "Doubles Incoming Knockback");
        this.addGeasEffect("rocket_jumping", "Wind Charges Provide Greater Propulsion");
        this.addGeasEffect("wind_charge_exhaustion", "Continuous Activations Weigh You Down");
        this.addGeasEffect("weak_legs", "Fall Damage Is Amplified");
        this.addGeasEffect("mining_buffs", "Breaking Blocks Or Taking Damage Grants Flamekeeper's Fervor");
        this.addGeasEffect("flamekeeper", "Flamekeeper's Fervor grants Mining and Attack Speed");
        this.addGeasEffect("self_immolation", "High Fervor Briefly Ignites You When Struck");
        this.addGeasEffect("hotter_fire", "Fire Effects You Apply Are Accelerated");
        this.addGeasEffect("extinguish_hurt", "Being Extinguished Hurts You");
        this.addGeasEffect("explosion_lover", "Absorbed Explosions Grant Pyromaniac's Fervor");
        this.addGeasEffect("pyromaniac", "Pyromaniac's Fervor grants Mining and Movement Speed");
        this.addGeasEffect("explosion_resistance", "You Gain Powerful Explosion Resistance");
        this.addGeasEffect("explosion_fire", "High Fervor Ignites You Upon Blast Impact");
        this.addGeasEffect("scary_fire", "Fire Damage Is Amplified");
        this.addGeasEffect("trial_of_faith", "Gluttony Becomes Trial of Faith");
        this.addGeasEffect("trial_of_faith_healing", "Trial of Faith Increases Healing Received");
        this.addGeasEffect("rotten_healing", "Eating Rotten Foods Heals You");
        this.addGeasEffect("no_passive_healing", "Saturation And Hunger No Longer Restore Health");
        this.addGeasEffect("no_normal_foods", "You Must Only Eat Rot");
        this.addGeasEffect("desperate_need", "Gluttony Becomes Desperate Need");
        this.addGeasEffect("desperate_need_scythe_proficiency", "Desperate Need Substantially Increases Scythe Proficiency");
        this.addGeasEffect("desperate_need_betrayal", "The Rot Will Consume You");
        this.addGeasEffect("wyrd_reconstruction", "Death Triggers Resurrection");
        this.addGeasEffect("wyrd_reconstruction_spirits", "Resurrection Repeatedly Activates Spirit-Collection Effects");
        this.addGeasEffect("wyrd_reconstruction_cooldown", "Arcane Resonance is Dampened Until Recharged");
        this.addGeasEffect("spirits_hunger", "Spirit Collection Drains Hunger");
        this.addGeasEffect("malignant_crit_leech", "Malignant Deliverance Leeches Life Essence");
        this.addGeasEffect("malignant_crit_healing_overexertion", "Repeated Activations Gradually Diminish All Healing");
        this.addGeasEffect("malignant_crit_combo", "Malignant Deliverance Repeatedly Slashes Targets");
        this.addGeasEffect("malignant_crit_health_condition", "Prevents Malignant Deliverance When Wounded");
        this.addGeasEffect("malignant_crit_reinforcement", "Malignant Deliverance Reinforces Armor");
        this.addGeasEffect("malignant_crit_reduced_damage", "Reduces Malignant Deliverance Damage");
        this.addGeasEffect("staff_homing", "Staff Projectiles Home In on Targets");
        this.addGeasEffect("staff_autofire", "Staff Charges Automatically Fire");
        this.addGeasEffect("inverted_heart", "Injuries, Emotions, Senses are Shared with Witnesses");
        this.addGeasEffect("inverted_heart_arcane_resonance", "Arcane Resonance Favors Influence Radius");
        this.addGeasEffect("gleeful_target", "Ailments, Blessings, Curses are Paused When Struck");
        this.addGeasEffect("gleeful_target_arcane_resonance", "Arcane Resonance Aids Stasis Duration");
        this.addGeasEffect("presence_breaker", "Refusal, Detachment, Exile is Forced onto Targets");
        this.addGeasEffect("presence_breaker_arcane_resonance", "Arcane Resonance Favors Exile Duration");
        this.add("malum.effect.soul_based_damage", "Deals Soul-Rending Damage");
        this.add("malum.effect.weight_of_worlds_crit", "Sometimes Strikes With Critical Force");
        this.add("malum.effect.weight_of_worlds_kill", "Kills Guarantee a Critical Strike");
        this.add("malum.effect.edge_of_deliverance_crit", "Follow-up Strikes Hit Critically");
        this.add("malum.effect.edge_of_deliverance_unpowered_attack", "Non-Critical Strikes Deal Reduced Damage");
        this.add("malum.effect.hex_bolts", "Charges a Burst of Mnemonic Blades");
        this.add("malum.effect.erosive_spread", "Charges a Spread of Eroding Sub-munitions");
        this.add("malum.effect.erosive_silence", "Erosion Damage Silences Targets");
        this.add("malum.effect.unwinding_chaos_volley", "Charges a Volley of Composite Energy");
        this.add("malum.effect.unwinding_chaos_burn", "Burn Damage Recovers Charges");
        this.add("malum.effect.sundering_anchor_damage_split", "Damage is Split Between Several Cuts");
        this.add("malum.effect.sundering_anchor_hatred", "Each Cut Applies Hatred");
        this.add("malum.effect.wayne_june.0", "The Iron Crown. Enigmatic, and Ubiquitous");
        this.add("malum.effect.wayne_june.1", "A Semi-Circle, Radiating Five Points of Power. A Symbol Hidden Deep in the Iconography of Every Ancient Empire");
        this.add("malum.effect.wayne_june.2", "The Point of No Return Welcomes You, With Open Arms");
        this.add("malum.effect.wayne_june.3", "The Greatest Horror It Would Seem, Is Nothing At All");
        this.add("malum.effect.wayne_june.4", "An Ocean of Emptiness, Slowly Swallowing the World");
        this.add("malum.effect.wayne_june.5", "A Nebulous Nightmare, an Apocalypse that Only We Can Oppose");
        this.add("malum.effect.wayne_june.6", "Stagnant And Sprawling, This Hellish Abyss Extends Beyond Sanity Itself");
        this.add("malum.effect.wayne_june.7", "We Travel Through The Incalculable Dimensions Of Human Weakness");
        this.add("malum.effect.wayne_june.8", "Success, So Long Pursued, Is Rewarded Only With Creeping Revalation");
        this.add("malum.effect.wayne_june.9", "You Have Cowered In Your Cowering Denial Long Enough");
        this.add("malum.effect.wayne_june.10", "Let Us Drag Your Agglutinated Indignities Out Into The Light");
        this.add("malum.spirit.flavour.sacred", "Innocent");
        this.add("malum.spirit.flavour.wicked", "Malicious");
        this.add("malum.spirit.flavour.arcane", "Fundamental");
        this.add("malum.spirit.flavour.eldritch", "Esoteric");
        this.add("malum.spirit.flavour.aerial", "Swift");
        this.add("malum.spirit.flavour.aqueous", "Malleable");
        this.add("malum.spirit.flavour.infernal", "Radiant");
        this.add("malum.spirit.flavour.earthen", "Steady");
        this.add("malum.spirit.flavour.umbral", "Antithesis");
        this.add("malum.jei.spirit_infusion", "Spirit Infusion");
        this.add("malum.jei.spirit_focusing", "Spirit Focusing");
        this.add("malum.jei.spirit_repair", "Spirit Repair");
        this.add("malum.jei.spirit_rite", "Spirit Rites");
        this.add("malum.jei.runeworking", "Runeworking");
        this.add("malum.jei.weeping_well", "The Weeping Well");
        this.add("malum.jei.spirit_transmutation", "The Unchained Rite");
        this.add("itemGroup.malum_basis_of_magic", "Malum: Study of Miracles");
        this.add("itemGroup.malum_arcane_construct", "Malum: The Earth Imbued");
        this.add("itemGroup.malum_scars_of_arcana", "Malum: Scars of Arcana");
        this.add("itemGroup.malum_metallurgic_magics", "Malum: Imitation Alchemy");
        this.add("itemGroup.malum_geas", "Malum: Sworn Oaths");
        this.add("itemGroup.malum_ritual_shards", "Malum: Ritual Shards");
        this.add("itemGroup.malum_cosmetics", "Malum: One's True Self");
        this.addDeathMessage(MalumDamageTypes.VOODOO, "%1$s had their soul shattered by %2$s", "%1$s had their soul shattered by %2$s using %3$s");
        this.addPlayerlessDeathMessage(MalumDamageTypes.VOODOO_PLAYERLESS, "%1$s had their soul shattered", "%1$s had their soul shattered while trying to escape %2$s");
        this.addPlayerlessDeathMessage(MalumDamageTypes.VOID, "%1$s underwent reality erosion", "%1$s underwent reality erosion while trying to escape %2$s");
        this.addPlayerlessDeathMessage(MalumDamageTypes.KARMIC, "%1$s was forsworn", "%1$s was forsworn while trying to escape %2$s");
        this.addPlayerlessDeathMessage(MalumDamageTypes.ROT, "%1$s was consumed by rot", "%1$s was consumed by rot while trying to escape %2$s");
        this.addDeathMessage(MalumDamageTypes.NITRATE, "%1$s had their soul detonated by %2$s", "%1$s had their soul detonated by %2$s using %3$s");
        this.addPlayerlessDeathMessage(MalumDamageTypes.NITRATE_PLAYERLESS, "%1$s had their soul detonated", "%1$s had their soul detonated while trying to escape %2$s");
        this.addDeathMessage(MalumDamageTypes.SCYTHE_MELEE, "%1$s was sliced in half by %2$s", "%1$s was sliced in half by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.SCYTHE_SWEEP, "%1$s was sliced in half by %2$s", "%1$s was sliced in half by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.SCYTHE_REBOUND, "%1$s was boomeranged by %2$s", "%1$s was boomeranged by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.SCYTHE_ASCENSION, "%1$s was cleaved using ascension by %2$s", "%1$s was cleaved using ascension by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.SCYTHE_COMBO, "%1$s was sliced in half and then again by %2$s", "%1$s was sliced in half and then again by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.SCYTHE_MAELSTROM, "%1$s was sliced and diced by %2$s", "%1$s was sliced and diced by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.HIDDEN_BLADE_PHYSICAL_COUNTER, "%1$s was sliced into innumerable pieces by %2$s", "%1$s was sliced into innumerable pieces by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.HIDDEN_BLADE_MAGIC_COUNTER, "%1$s had their soul sliced into innumerable pieces by %2$s", "%1$s had their soul sliced into innumerable pieces by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.TYRVING, "%1$s had their soul scarred by %2$s", "%1$s had their soul scarred by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.SUNDERING_ANCHOR_PHYSICAL_COMBO, "%1$s was struck down through torment by %2$s", "%1$s was struck down through torment by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.SUNDERING_ANCHOR_MAGIC_COMBO, "%1$s had their soul struck down through torment by %2$s", "%1$s had their soul struck down through torment by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.WARLOCK_SPIRIT_IMPACT, "%1$s had their soul shattered by %2$s", "%1$s had their soul shattered by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.BERSERKER_SPIRIT_IMPACT, "%1$s had their soul shattered by %2$s", "%1$s had their soul shattered by %2$s using %3$s");
        this.addDeathMessage(MalumDamageTypes.INVERTED_HEART_PROPAGATION, "%1$s was caught in %2$s's karmic flow", "%1$s was caught in %2$s's karmic flow using %3$s");
        this.addDeathMessage(MalumDamageTypes.INVERTED_HEART_RETALIATION, "%1$s was caught in %2$s's karmic flow", "%1$s was caught in %2$s's karmic flow using %3$s");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.GAIAS_BULWARK, "An earthen carapace surrounds your body, functioning as extra armor.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.EARTHEN_MIGHT, "Your fists and tools are reinforced with earth, increasing your strength.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.MINERS_RAGE, "Your tools are bolstered with radiance, increasing your mining and attack speed.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.IFRITS_EMBRACE, "The warm embrace of fire coats your soul, mending your seared scars.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.ZEPHYRS_COURAGE, "The zephyr propels you forward, increasing your movement speed.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.AETHERS_CHARM, "The heavens call for you, increasing jump height and decreasing gravity.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.POSEIDONS_GRASP, "You reach out for further power, increasing your reach and item pickup distance.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.ANGLERS_LURE, "Let any fish who meets my gaze learn the true meaning of fear; for I am the harbinger of death. The bane of creatures sub-aqueous, my rod is true and unwavering as I cast into the aquatic abyss. A man, scorned by this uncaring Earth, finds solace in the sea. My only friend, the worm upon my hook. Wriggling, writhing, struggling to surmount the mortal pointlessness that permeates this barren world. I am alone. I am empty. And yet, I fish.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.ASCENSION, "Eases your fall and reduces gravity after a successful Scythe Ascenison.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.GLUTTONY, "You feed on the vulnerable, increasing magic proficiency at the expense of hunger./");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.CANCEROUS_GROWTH, "You are emboldened by uncontrolled growth, increasing maximum health.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.ECHOING_ARCANA, "You are made wiser by uncontrolled magnification, increasing arcane resonance.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.WICKED_INTENT, "You bring forth a powerful counter attack, your next scythe attack will unleash an impossible volley of cuts.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.SILENCED, "You are silenced, leaving your magical capabilities neutered.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.GRIM_CERTAINTY, "The Weight of Worlds oscillates, sealing the next strike as a critical blow.");
        this.addJEEDEffectDescription((Supplier<MobEffect>)MalumMobEffects.IMMINENT_DELIVERANCE, "The Edge of Deliverance oscillates, sealing it's next strike as a critical blow.");
        this.addTetraMaterial("malignant_pewter", "Malignant Pewter");
        this.addTetraMaterial("soul_stained_steel", "Soulstained Steel");
        this.addTetraMaterial("hallowed_gold", "Hallowed Gold");
        this.addTetraMaterial("runewood", "Runewood");
        this.addTetraMaterial("soulwood", "Soulwood");
        this.addTetraMaterial("tainted_rock", "Tainted Rock");
        this.addTetraMaterial("twisted_rock", "Twisted Rock");
        this.addTetraMaterial("soulwoven_silk", "Soulwoven Silk");
        this.addTetraImprovement("malum.soul_strike", "Soul Strike", "The item's material allows it to strike the soul.");
        this.addEnchantmentNameAndDescription(EnchantmentKeys.ANIMATED, "Improves attack speed.");
        this.addEnchantmentNameAndDescription(EnchantmentKeys.HAUNTED, "Improves the Weapon's Magic Damage");
        this.addEnchantmentNameAndDescription(EnchantmentKeys.SPIRIT_PLUNDER, "Reaps extra Spirits when shattering a soul.");
        this.addEnchantmentNameAndDescription(EnchantmentKeys.REBOUND, "Allows the Scythe to be thrown when used.");
        this.addEnchantmentNameAndDescription(EnchantmentKeys.ASCENSION, "Enables the Scythe to propel the player upwards, damaging nearby enemies when used.");
        this.addEnchantmentNameAndDescription(EnchantmentKeys.REPLENISHING, "Restores Spell Charges when dealing melee damage with the staff.");
        this.addEnchantmentNameAndDescription(EnchantmentKeys.CAPACITOR, "Adds additional Spell Charges for use with the staff");
        this.addAttributeLibAttributeDescription(MalumAttributes.SCYTHE_PROFICIENCY, "Damage multiplier for Scythes");
        this.addAttributeLibAttributeDescription(MalumAttributes.SPIRIT_SPOILS, "Flat increase to spirits looted from slain foes");
        this.addAttributeLibAttributeDescription(MalumAttributes.ARCANE_RESONANCE, "Bonus potency for spirit-collection effects");
        this.addAttributeLibAttributeDescription(MalumAttributes.HEALING_MULTIPLIER, "An increase in healing received");
        this.addAttributeLibAttributeDescription(MalumAttributes.SOUL_WARD_INTEGRITY, "A percentile increase in durability for Soul Ward");
        this.addAttributeLibAttributeDescription(MalumAttributes.SOUL_WARD_RECOVERY_RATE, "A percentile increase in recovery rate for Soul Ward");
        this.addAttributeLibAttributeDescription(MalumAttributes.SOUL_WARD_RECOVERY_MULTIPLIER, "A percentile increase the amount of Soul Ward recovered");
        this.addAttributeLibAttributeDescription(MalumAttributes.SOUL_WARD_CAPACITY, "The capacity for Soul Ward");
        this.addAttributeLibAttributeDescription(MalumAttributes.CHARGE_DURATION, "The duration for charging a staff");
        this.addAttributeLibAttributeDescription(MalumAttributes.CHARGE_CAPACITY, "The capacity for Spell Charges");
        this.addAttributeLibAttributeDescription(MalumAttributes.CHARGE_RECOVERY_RATE, "A percentile increase in recovery rate for Spell Charges");
        this.addAttributeLibAttributeDescription(MalumAttributes.GEAS_LIMIT, "The limit for active Geas Bindings that can be sworn at once");
        this.addAttributeLibAttributeDescription(MalumAttributes.MALIGNANT_CONVERSION, "A percentile conversion rate in which certain magical attributes are converted into armor, armor toughness and magic resistance");
    }

    public String getName() {
        return "Malum Lang Entries";
    }

    public String makeProper(String s) {
        s = s.replaceAll("Of", "of").replaceAll("The", "the").replaceAll("Soul Stained", "Soulstained").replaceAll("Soul Hunter", "Soulhunter");
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public void addCurioEffect(String identifier, String name) {
        this.add("malum.effect.curio." + identifier, name);
    }

    public void addGeasEffect(String identifier, String name) {
        this.add("malum.effect.geas." + identifier, name);
    }

    public void addRite(TotemicRiteType riteType, String basicName, String corruptName) {
        this.add(riteType.getLangKey(false), basicName);
        this.add(riteType.getLangKey(true), corruptName);
    }

    public void addRiteEffectCategory(TotemicRiteEffect.MalumRiteEffectCategory category) {
        this.add(category.getTranslationKey(), DataHelper.toTitleCase((String)category.name().toLowerCase(), (String)"_"));
    }

    public void addGeasDescription(GeasEffectType effectType, String description) {
        this.add(effectType.getLangKey() + ".tooltip", description);
    }

    public void addTetraMaterial(String identifier, String name) {
        this.add("tetra.material." + identifier, name);
        this.add("tetra.material." + identifier + ".prefix", name);
    }

    public void addTetraImprovement(String identifier, String name, String description) {
        this.add("tetra.improvement." + identifier + ".name", name);
        this.add("tetra.improvement." + identifier + ".description", description);
    }

    public void addPlayerlessDeathMessage(ResourceKey<DamageType> damageType, String base, String player) {
        String key = "death.attack." + damageType.location().getPath();
        this.add(key, base);
        this.add(key + ".player", player);
    }

    public void addDeathMessage(ResourceKey<DamageType> damageType, String base, String item) {
        String key = "death.attack." + damageType.location().getPath();
        this.add(key, base);
        this.add(key + ".item", item);
    }

    public void addEnchantmentNameAndDescription(ResourceKey<Enchantment> enchantment, String desc) {
        String name = enchantment.location().getPath();
        String key = "enchantment.malum." + name;
        this.add(key, DataHelper.toTitleCase((String)name, (String)"_"));
        this.add(key + ".desc", desc);
    }

    public void addAttributeLibAttributeDescription(DeferredHolder<Attribute, Attribute> attribute, String desc) {
        this.add("attribute.name.malum." + attribute.getId().getPath() + ".desc", desc);
    }

    public void addJEEDEffectDescription(Supplier<MobEffect> mobEffectSupplier, String description) {
        this.add(mobEffectSupplier.get().getDescriptionId() + ".description", description);
    }

    public String correctSoundName(String name) {
        if (name.endsWith("_step")) {
            return "footsteps";
        }
        if (name.endsWith("_place")) {
            return "block_placed";
        }
        if (name.endsWith("_break")) {
            return "block_broken";
        }
        if (name.endsWith("_hit")) {
            return "block_breaking";
        }
        return name;
    }

    public String correctItemName(String name) {
        if (name.contains("music_disc")) {
            return "music_disc";
        }
        if (!name.endsWith("_bricks") && name.contains("bricks")) {
            name = name.replaceFirst("bricks", "brick");
        }
        if (!name.endsWith("_boards") && name.contains("boards")) {
            name = name.replaceFirst("boards", "board");
        }
        if ((name.contains("_fence") || name.contains("_button")) && name.contains("planks")) {
            name = name.replaceFirst("_planks", "");
        }
        if (name.startsWith("trans_")) {
            return name;
        }
        return this.makeProperEnglish(name);
    }

    public String makeProperEnglish(String name) {
        String[] replacements = new String[]{"ns_", "rs_", "ts_"};
        String properName = name;
        for (String replacement : replacements) {
            int index = properName.indexOf(replacement);
            if (index == -1) continue;
            properName = properName.replaceFirst("s_", "'s_");
            break;
        }
        return properName;
    }
}

