/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.builder;

import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.recipe.builder.LodestoneRecipeBuilder;

public class SpiritRepairRecipeBuilder
implements LodestoneRecipeBuilder<SpiritRepairRecipe> {
    public final String itemIdRegex;
    public final String modIdRegex;
    public final float durabilityPercentage;
    public final List<Item> inputs = new ArrayList<Item>();
    public final SizedIngredient repairMaterial;
    public final List<SpiritIngredient> spirits = new ArrayList<SpiritIngredient>();
    public Item repairOutputOverride = Items.AIR;
    public Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public SpiritRepairRecipeBuilder(String itemIdRegex, String modIdRegex, float durabilityPercentage, SizedIngredient repairMaterial) {
        this.itemIdRegex = itemIdRegex;
        this.modIdRegex = modIdRegex;
        this.durabilityPercentage = durabilityPercentage;
        this.repairMaterial = repairMaterial;
    }

    public SpiritRepairRecipeBuilder(String itemIdRegex, float durabilityPercentage, Ingredient repairMaterial, int repairMaterialCount) {
        this(itemIdRegex, "", durabilityPercentage, new SizedIngredient(repairMaterial, repairMaterialCount));
    }

    public SpiritRepairRecipeBuilder(float durabilityPercentage, Ingredient repairMaterial, int repairMaterialCount) {
        this("", "", durabilityPercentage, new SizedIngredient(repairMaterial, repairMaterialCount));
    }

    public SpiritRepairRecipeBuilder addItem(Item item) {
        this.inputs.add(item);
        return this;
    }

    public SpiritRepairRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritIngredient(type, count));
        return this;
    }

    public SpiritRepairRecipeBuilder overrideOutput(Item repairOutputOverride) {
        this.repairOutputOverride = repairOutputOverride;
        return this;
    }

    public SpiritRepairRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public void tweakAdvancement(Advancement.Builder advancement) {
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
    }

    public SpiritRepairRecipe buildRecipe(ResourceLocation resourceLocation) {
        ArrayList<ResourceLocation> inputIds = new ArrayList<ResourceLocation>();
        for (Item input : this.inputs) {
            inputIds.add(BuiltInRegistries.ITEM.getKey((Object)input));
        }
        return new SpiritRepairRecipe(this.durabilityPercentage, this.itemIdRegex, this.modIdRegex, inputIds, this.repairMaterial, this.spirits, this.repairOutputOverride);
    }

    public String getRecipeSubfolder() {
        return "spirit_repair";
    }
}

