/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class SpiritDiodeParticleEffects {
    public static void openSpiritDiode(NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        ClientLevel level = Minecraft.getInstance().level;
        RandomSource random = level.random;
        for (int i = 0; i < 2; ++i) {
            int lifeDelay = i * 3;
            float yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.02f);
            ParticleEffectSpawner square = SpiritDiodeParticleEffects.waveformSquare((Level)level, positionData.getAsVector(), colorData.getColor());
            square.getBuilder().setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional()).setLifeDelay(lifeDelay).setMotion(0.0, (double)yVelocity, 0.0);
            square.spawnParticles();
        }
    }

    public static void closeSpiritDiode(NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        ClientLevel level = Minecraft.getInstance().level;
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int lifeDelay = i * 2;
            ParticleEffectSpawner square = SpiritDiodeParticleEffects.waveformSquare((Level)level, positionData.getAsVector(), colorData.getColor());
            square.getBuilder().setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)2.0f, (float)0.0f).setEasing(Easing.EXPO_OUT).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).setLifeDelay(lifeDelay);
            square.spawnParticles();
        }
    }

    public static ParticleEffectSpawner waveformSquare(Level level, Vec3 pos, ColorParticleData colorData) {
        RandomSource rand = level.random;
        GenericParticleData scaleData = GenericParticleData.create((float)0.1f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.5f, (float)0.6f), (float)0.5f).setEasing(Easing.SINE_OUT, Easing.SINE_IN).setCoefficient(RandomHelper.randomBetween((RandomSource)rand, (float)1.0f, (float)1.25f)).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.99f));
        WorldParticleBuilder squares = WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.SQUARE.get())).setTransparencyData(GenericParticleData.create((float)0.7f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setScaleData(scaleData).setColorData(colorData).setLifetime(15).enableNoClip().addTickActor(behavior);
        Consumer<WorldParticleBuilder> squareSpawner = b -> b.spawn(level, pos.x, pos.y, pos.z).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, pos.x, pos.y, pos.z);
        return new ParticleEffectSpawner(squares, squareSpawner);
    }
}

