/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticles;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SpiritLightSpecs {
    public static void coolLookingShinyThing(Level level, Vec3 pos, MalumSpiritType spiritType) {
        ParticleEffectSpawner centralLightSpecs = SpiritLightSpecs.spiritLightSpecs(level, pos, spiritType, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC_SMALL.get()));
        centralLightSpecs.getBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(6.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(3.0f));
        centralLightSpecs.getBloomBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(4.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(3.0f));
        centralLightSpecs.spawnParticles();
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, ColorParticleData colorData, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC_SMALL.get()), colorData, distance, rotatingSpecs, modifier);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, ColorParticleData colorData, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, colorData, options).act(modifier), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, ColorParticleData colorData, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC_SMALL.get()), colorData, distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, ColorParticleData colorData, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, colorData, options), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, MalumSpiritType spiritType, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC_SMALL.get()), spiritType, distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, MalumSpiritType spiritType, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, spiritType, options), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, MalumSpiritType spiritType, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC_SMALL.get()), spiritType, distance, rotatingSpecs, modifier);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, MalumSpiritType spiritType, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, spiritType, options).act(modifier), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, Function<Vec3, ParticleEffectSpawner> particleSpawner, float distance, int rotatingSpecs) {
        long gameTime = level.getGameTime();
        if (level.getGameTime() % 2L == 0L) {
            for (int i = 0; i < rotatingSpecs; ++i) {
                long offsetGameTime = gameTime + (long)i * 120L;
                double yOffset = Math.sin((float)(offsetGameTime % 360L) / 30.0f) * (double)0.1f;
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)pos.add(0.0, yOffset, 0.0), (float)distance, (float)i, (float)rotatingSpecs, (float)gameTime, (float)160.0f);
                ParticleEffectSpawner lightSpecs = particleSpawner.apply(offsetPosition);
                lightSpecs.getBuilder().multiplyLifetime(2.0f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                lightSpecs.getBloomBuilder().act(b -> b.multiplyLifetime(1.4f).modifyData(List.of(() -> ((WorldParticleBuilder)b).getScaleData(), () -> ((WorldParticleBuilder)b).getTransparencyData()), d -> d.multiplyValue(0.6f)));
                lightSpecs.spawnParticles();
            }
        }
        ParticleEffectSpawner lightSpecs = particleSpawner.apply(pos);
        lightSpecs.getBuilder().multiplyLifetime(0.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.7f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.5f));
        lightSpecs.getBloomBuilder().multiplyLifetime(0.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.3f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f));
        lightSpecs.spawnParticles();
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, MalumSpiritType spiritType) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, spiritType, new WorldParticleOptions(MalumParticles.LIGHT_SPEC_SMALL));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, ColorParticleData colorData) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, colorData, new WorldParticleOptions(MalumParticles.LIGHT_SPEC_SMALL));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, MalumSpiritType spiritType, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, ColorParticleData colorData, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, WorldParticleBuilder::create);
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier) {
        WorldParticleBuilder builder = builderSupplier.apply(options);
        WorldParticleBuilder bloomBuilder = builderSupplier.apply(new WorldParticleOptions(LodestoneParticleTypes.WISP_PARTICLE));
        return SpiritLightSpecs.spiritLightSpecs(level, pos, builder, bloomBuilder);
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, WorldParticleBuilder builder, WorldParticleBuilder bloomBuilder) {
        RandomSource rand = level.getRandom();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)10, (int)20);
        WorldParticleBuilder worldParticleBuilder = builder.setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.0f).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)0.025f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.3f), (float)0.0f).build()).setLifetime(lifetime).enableNoClip().addTickActor(slowDown);
        WorldParticleBuilder bloomParticleBuilder = SpiritLightSpecs.spiritBloom(level, bloomBuilder, lifetime).setSpinData(spinData).addTickActor(slowDown);
        return new ParticleEffectSpawner(level, pos, worldParticleBuilder, bloomParticleBuilder);
    }

    public static WorldParticleBuilder spiritBloom(Level level, MalumSpiritType spiritType, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, spiritType, new WorldParticleOptions(LodestoneParticleTypes.WISP_PARTICLE), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, ColorParticleData colorData, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, colorData, new WorldParticleOptions(LodestoneParticleTypes.WISP_PARTICLE), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, MalumSpiritType spiritType, WorldParticleOptions options, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, ColorParticleData colorData, WorldParticleOptions options, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, builderSupplier.apply(options), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, WorldParticleBuilder builder, int lifetime) {
        RandomSource rand = level.random;
        return builder.setTransparencyData(GenericParticleData.create((float)0.35f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.04f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.08f, (float)0.14f), (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setLifetime(lifetime).enableNoClip();
    }
}

