/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;

public class TotemParticleEffects {
    public static void activeTotemPoleParticles(TotemPoleBlockEntity totemPoleBlockEntity) {
        MalumSpiritType spiritType = totemPoleBlockEntity.spirit;
        Level level = totemPoleBlockEntity.getLevel();
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        if (gameTime % 12L == 0L) {
            int offset = (totemPoleBlockEntity.getBlockPos().getY() - totemPoleBlockEntity.totemBaseYLevel) * 40;
            gameTime += (long)offset;
            float time = 480.0f;
            for (int i = 0; i < 2; ++i) {
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.005f, (float)0.015f);
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)totemPoleBlockEntity.getBlockPos().getCenter(), (float)0.9f, (float)i, (float)2.0f, (float)gameTime, (float)480.0f);
                offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(i * 240)) % 480.0f / 480.0f) * 0.25 - 0.25, 0.0);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType);
                lightSpecs.getBuilder().multiplyLifetime(4.5f).setMotion(0.0, (double)velocity, 0.0).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(3.0f).setMotion(0.0, (double)velocity, 0.0).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void activateTotemPoleParticles(Level level, MalumNetworkedParticleEffectColorData colorData, Vec3 position) {
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        float time = 16.0f;
        for (int i = 0; i < 16; ++i) {
            float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.005f, (float)0.015f);
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)0.85f, (float)i, (float)16.0f, (float)gameTime, (float)16.0f);
            offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(i * 240)) % 16.0f / 16.0f) * 0.25 - 0.25, 0.0);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
            lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(0.0, (double)velocity, 0.0).setLifeDelay(i).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
            lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(0.0, (double)velocity, 0.0).setLifeDelay(i).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
            lightSpecs.spawnParticles();
        }
    }

    public static void triggerEntityEffect(Level level, MalumNetworkedParticleEffectColorData colorData, Vec3 position) {
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        float time = 16.0f;
        for (int i = 0; i < 8; ++i) {
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)0.7f, (float)i, (float)8.0f, (float)gameTime, (float)16.0f);
            offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(i * 480)) % 16.0f / 16.0f) * 0.25 - 0.25, 0.0);
            for (int j = 0; j < 3; ++j) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getColor());
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.03f);
                Vec3 motion = offsetPosition.subtract(position).normalize().scale((double)velocity);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(motion).setLifeDelay(j * 6).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(motion).setLifeDelay(j * 6).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void triggerBlockFallEffect(Level level, MalumNetworkedParticleEffectColorData colorData, BlockPos position) {
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            for (int j = 0; j < 2; ++j) {
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)(position.getY() + j), (double)(position.getZ() + zOffset));
                float motion = RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.06f);
                Vec3 velocity = position.getCenter().subtract(offsetPosition).add(0.0, -2.0, 0.0).normalize().scale((double)motion);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(velocity).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void triggerBlockEffect(Level level, MalumNetworkedParticleEffectColorData colorData, BlockPos position) {
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            float xMotion = (float)(i % 2) * (i > 1 ? 0.06f : -0.06f);
            float zMotion = (float)((i + 1) % 2) * (i > 1 ? -0.06f : 0.06f);
            for (int j = 0; j < 2; ++j) {
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)(position.getY() + j), (double)(position.getZ() + zOffset));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void triggerBlockGrowEffect(Level level, MalumNetworkedParticleEffectColorData colorData, BlockPos position) {
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            float xMotion = (float)(i % 2) * (i > 1 ? 0.06f : -0.06f);
            float yMotion = 0.08f;
            float zMotion = (float)((i + 1) % 2) * (i > 1 ? -0.06f : 0.06f);
            for (int j = 0; j < 6; ++j) {
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)(position.getY() + j % 2), (double)(position.getZ() + zOffset));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(3.5f).setMotion((double)xMotion, (double)yMotion, (double)zMotion).setLifeDelay(j / 2 * 4).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(2.5f).setMotion((double)xMotion, (double)yMotion, (double)zMotion).setLifeDelay(j / 2 * 4).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }
}

