/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked;

import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectColorData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPayload;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public abstract class MalumNetworkedWeaponParticleEffectType<T extends WeaponParticleEffectType.WeaponParticleEffectData>
extends WeaponParticleEffectType<T> {
    public MalumNetworkedWeaponParticleEffectType(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectColorData>> getColorCodec() {
        return Optional.of(MalumNetworkedParticleEffectColorData.STREAM_CODEC);
    }

    protected void castAndAct(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, NetworkedParticleEffectColorData colorData, NetworkedParticleEffectExtraData extraData) {
        this.act(level, random, positionData, (MalumNetworkedParticleEffectColorData)colorData, (T)((WeaponParticleEffectType.WeaponParticleEffectData)extraData));
    }

    public abstract void act(Level var1, RandomSource var2, NetworkedParticleEffectPositionData var3, MalumNetworkedParticleEffectColorData var4, T var5);

    public final void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, NetworkedParticleEffectColorData colorData, T extraData) {
    }

    public MalumWeaponParticleEffectBuilder<T> createEffect(BlockPos position) {
        return this.createEffect().at(position);
    }

    public MalumWeaponParticleEffectBuilder<T> createEffect(Vec3 position) {
        return this.createEffect().at(position);
    }

    public MalumWeaponParticleEffectBuilder<T> createEffect(Entity target) {
        return this.createEffect().at(target);
    }

    public MalumWeaponParticleEffectBuilder<T> createEffect() {
        return new MalumWeaponParticleEffectBuilder(this);
    }

    public static class MalumWeaponParticleEffectBuilder<T extends WeaponParticleEffectType.WeaponParticleEffectData>
    extends WeaponParticleEffectType.WeaponParticleEffectBuilder<T> {
        public MalumWeaponParticleEffectBuilder(WeaponParticleEffectType<T> type) {
            super(type);
        }

        public MalumWeaponParticleEffectBuilder<T> color(Item item) {
            if (item instanceof ISpiritAffiliatedItem) {
                ISpiritAffiliatedItem spiritAffiliatedItem = (ISpiritAffiliatedItem)item;
                return this.color(new MalumNetworkedParticleEffectColorData(spiritAffiliatedItem.getDefiningSpiritType()));
            }
            return this;
        }

        public MalumWeaponParticleEffectBuilder<T> color(MalumSpiritType ... spiritTypes) {
            return this.color(new MalumNetworkedParticleEffectColorData(spiritTypes));
        }

        public MalumWeaponParticleEffectBuilder<T> color(NetworkedParticleEffectColorData color) {
            if (color instanceof MalumNetworkedParticleEffectColorData) {
                MalumNetworkedParticleEffectColorData malumColor = (MalumNetworkedParticleEffectColorData)color;
                return (MalumWeaponParticleEffectBuilder)super.color((NetworkedParticleEffectColorData)malumColor);
            }
            return (MalumWeaponParticleEffectBuilder)super.color((NetworkedParticleEffectColorData)MalumNetworkedParticleEffectColorData.fromColors(color.getColors()));
        }

        public MalumWeaponParticleEffectBuilder<T> originatesFrom(Entity source) {
            return (MalumWeaponParticleEffectBuilder)super.originatesFrom(source);
        }

        public MalumWeaponParticleEffectBuilder<T> targets(Entity target) {
            return (MalumWeaponParticleEffectBuilder)super.targets(target);
        }

        public MalumWeaponParticleEffectBuilder<T> aimedAt(Vec3 direction) {
            return (MalumWeaponParticleEffectBuilder)super.aimedAt(direction);
        }

        public MalumWeaponParticleEffectBuilder<T> tiedToTarget() {
            return (MalumWeaponParticleEffectBuilder)super.tiedToTarget();
        }

        public MalumWeaponParticleEffectBuilder<T> mirroredRandomly(RandomSource random) {
            return (MalumWeaponParticleEffectBuilder)super.mirroredRandomly(random);
        }

        public MalumWeaponParticleEffectBuilder<T> mirrored() {
            return (MalumWeaponParticleEffectBuilder)super.mirrored();
        }

        public MalumWeaponParticleEffectBuilder<T> mirrored(boolean isMirrored) {
            return (MalumWeaponParticleEffectBuilder)super.mirrored(isMirrored);
        }

        public MalumWeaponParticleEffectBuilder<T> randomSlashRotation(RandomSource random) {
            return (MalumWeaponParticleEffectBuilder)super.randomSlashRotation(random);
        }

        public MalumWeaponParticleEffectBuilder<T> verticalSlashRotation() {
            return (MalumWeaponParticleEffectBuilder)super.verticalSlashRotation();
        }

        public MalumWeaponParticleEffectBuilder<T> slashRotation(float slashRotation) {
            return (MalumWeaponParticleEffectBuilder)super.slashRotation(slashRotation);
        }

        public MalumWeaponParticleEffectBuilder<T> setOffsetsFromHand(InteractionHand hand) {
            return (MalumWeaponParticleEffectBuilder)super.setOffsetsFromHand(hand);
        }

        public MalumWeaponParticleEffectBuilder<T> horizontalOffset(float horizontalOffset) {
            return (MalumWeaponParticleEffectBuilder)super.horizontalOffset(horizontalOffset);
        }

        public MalumWeaponParticleEffectBuilder<T> forwardOffset(float forwardOffset) {
            return (MalumWeaponParticleEffectBuilder)super.forwardOffset(forwardOffset);
        }

        public MalumWeaponParticleEffectBuilder<T> upwardOffset(float upwardOffset) {
            return (MalumWeaponParticleEffectBuilder)super.upwardOffset(upwardOffset);
        }

        public MalumWeaponParticleEffectBuilder<T> randomOffset(RandomSource random, float min, float max) {
            return (MalumWeaponParticleEffectBuilder)super.randomOffset(random, min, max);
        }

        public MalumWeaponParticleEffectBuilder<T> absoluteOffset(Vec3 absoluteOffset) {
            return (MalumWeaponParticleEffectBuilder)super.absoluteOffset(absoluteOffset);
        }

        public MalumWeaponParticleEffectBuilder<T> deviation(float horizontalDeviation, float verticalDeviation, float deviationAngle) {
            return (MalumWeaponParticleEffectBuilder)super.deviation(horizontalDeviation, verticalDeviation, deviationAngle);
        }

        public MalumWeaponParticleEffectBuilder<T> deviation(float horizontalDeviation, float verticalDeviation) {
            return (MalumWeaponParticleEffectBuilder)super.deviation(horizontalDeviation, verticalDeviation);
        }

        public MalumWeaponParticleEffectBuilder<T> deviation(float deviation) {
            return (MalumWeaponParticleEffectBuilder)super.deviation(deviation);
        }

        public MalumWeaponParticleEffectBuilder<T> horizontalDeviation(float horizontalDeviation) {
            return (MalumWeaponParticleEffectBuilder)super.horizontalDeviation(horizontalDeviation);
        }

        public MalumWeaponParticleEffectBuilder<T> verticalDeviation(float verticalDeviation) {
            return (MalumWeaponParticleEffectBuilder)super.verticalDeviation(verticalDeviation);
        }

        public MalumWeaponParticleEffectBuilder<T> randomDeviationAngle(RandomSource random) {
            return (MalumWeaponParticleEffectBuilder)super.randomDeviationAngle(random);
        }

        public MalumWeaponParticleEffectBuilder<T> deviationAngle(float deviationAngle) {
            return (MalumWeaponParticleEffectBuilder)super.deviationAngle(deviationAngle);
        }

        public MalumWeaponParticleEffectBuilder<T> spawn(ServerLevel level) {
            return (MalumWeaponParticleEffectBuilder)super.spawn(level);
        }

        public MalumWeaponParticleEffectBuilder<T> at(BlockPos position) {
            return (MalumWeaponParticleEffectBuilder)super.at(position);
        }

        public MalumWeaponParticleEffectBuilder<T> at(Vec3 position) {
            return (MalumWeaponParticleEffectBuilder)super.at(position);
        }

        public MalumWeaponParticleEffectBuilder<T> at(Entity target) {
            return (MalumWeaponParticleEffectBuilder)super.at(target);
        }

        public MalumWeaponParticleEffectBuilder<T> at(NetworkedParticleEffectPositionData position) {
            return (MalumWeaponParticleEffectBuilder)super.at(position);
        }

        public MalumWeaponParticleEffectBuilder<T> color(Color color) {
            return (MalumWeaponParticleEffectBuilder)super.color(color);
        }

        public MalumWeaponParticleEffectBuilder<T> color(ColorParticleData color) {
            return (MalumWeaponParticleEffectBuilder)super.color(color);
        }

        public MalumWeaponParticleEffectBuilder<T> color(List<ColorParticleData> colors) {
            return (MalumWeaponParticleEffectBuilder)super.color(colors);
        }

        public MalumWeaponParticleEffectBuilder<T> customData(T extra) {
            return (MalumWeaponParticleEffectBuilder)super.customData(extra);
        }

        public MalumWeaponParticleEffectBuilder<T> spawn(Consumer<NetworkedParticleEffectPayload> sender) {
            return (MalumWeaponParticleEffectBuilder)super.spawn(sender);
        }
    }
}

