/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.attack;

import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.PointyDirectionalParticleBehavior;

public class SunderingAnchorSweepParticleEffect
extends MalumNetworkedParticleEffectType<NetworkedParticleEffectExtraData> {
    public SunderingAnchorSweepParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, NetworkedParticleEffectExtraData extraData) {
        float angle = random.nextFloat() * 6.28f;
        float x = Mth.sin((float)angle);
        float z = Mth.cos((float)angle);
        Vec3 direction = new Vec3((double)x, 0.0, (double)z);
        ParticleEffectSpawner slash = WeaponParticleEffects.spawnSlashParticle(level, positionData.getAsVector(), random.nextBoolean() ? MalumParticles.THIN_ROUNDABOUT_SLASH : MalumParticles.ROUNDABOUT_SLASH, colorData);
        int lifetime = RandomHelper.randomBetween((RandomSource)random, (int)8, (int)12);
        int directionScalar = random.nextBoolean() ? -1 : 1;
        slash.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).randomSpinOffset(random).build()).setLifetime(lifetime).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)2.0f, (float)3.0f)).build()).setMotion(direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.05f))).setRandomOffset(0.5).setBehavior((LodestoneParticleBehavior)PointyDirectionalParticleBehavior.pointyDirectional((Vec3)direction.scale((double)directionScalar)));
        slash.spawnParticles();
        slash.getBuilder().setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.3f).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)1.5f, (float)2.0f)).build()).setLifeDelay(lifetime);
        slash.spawnParticles();
        slash.getBuilder().setTransparencyData(GenericParticleData.create((float)0.3f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)1.2f, (float)1.6f)).build()).setLifeDelay(lifetime * 2);
        slash.spawnParticles();
    }
}

